/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.neon.internal.contrib.jgoodies.looks;

import java.awt.Toolkit;

public final class LookUtils {
    private static final String JAVA_SPEC_VERSION = LookUtils.getSystemProperty("java.specification.version");
    private static final String OS_NAME = LookUtils.getSystemProperty("os.name");
    private static final String OS_VERSION = LookUtils.getSystemProperty("os.version");
    public static final boolean IS_OS_MAC = LookUtils.startsWith(OS_NAME, "Mac");
    public static final boolean IS_OS_WINDOWS = LookUtils.startsWith(OS_NAME, "Windows");
    public static final boolean IS_OS_WINDOWS_95 = LookUtils.startsWith(OS_NAME, "Windows 9") && LookUtils.startsWith(OS_VERSION, "4.0");
    public static final boolean IS_OS_WINDOWS_98 = LookUtils.startsWith(OS_NAME, "Windows 9") && LookUtils.startsWith(OS_VERSION, "4.1");
    public static final boolean IS_OS_WINDOWS_NT = LookUtils.startsWith(OS_NAME, "Windows NT");
    public static final boolean IS_OS_WINDOWS_ME = LookUtils.startsWith(OS_NAME, "Windows") && LookUtils.startsWith(OS_VERSION, "4.9");
    public static final boolean IS_OS_MAC_YOSEMITE = IS_OS_MAC && LookUtils.startsWith(OS_VERSION, "10.10");
    public static final boolean IS_OS_MAC_EL_CAPITAN_OR_LATER = IS_OS_MAC && (LookUtils.startsWith(OS_VERSION, "10.11") || LookUtils.startsWith(OS_VERSION, "10.12") || LookUtils.startsWith(OS_VERSION, "10.13") || LookUtils.startsWith(OS_VERSION, "10.14"));
    public static final boolean IS_OS_MAC_MOJAVE_OR_LATER = IS_OS_MAC || LookUtils.startsWith(OS_VERSION, "10.14");
    public static final boolean IS_JAVA_9 = LookUtils.startsWith(JAVA_SPEC_VERSION, "9");
    public static final boolean IS_JAVA_10 = LookUtils.startsWith(JAVA_SPEC_VERSION, "10");
    public static final boolean IS_JAVA_11 = LookUtils.startsWith(JAVA_SPEC_VERSION, "11");
    public static final boolean IS_LOW_RESOLUTION = LookUtils.isLowResolution();

    private LookUtils() {
    }

    public static String getSystemProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static String getSystemProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException e) {
            return defaultValue;
        }
    }

    public static int getJavaMajorVersion() {
        String jvmVersionString = JAVA_SPEC_VERSION;
        int verIndex = jvmVersionString.indexOf("1.");
        if (verIndex >= 0) {
            jvmVersionString = jvmVersionString.substring(verIndex + 2);
        }
        return Integer.parseInt(jvmVersionString);
    }

    private static boolean isLowResolution() {
        return Toolkit.getDefaultToolkit().getScreenResolution() < 120;
    }

    private static boolean startsWith(String str, String prefix) {
        return str != null && str.startsWith(prefix);
    }
}

