/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.overlay;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public final class BottomLineOverlayPainter
implements SubstanceOverlayPainter {
    ColorSchemeSingleColorQuery colorSchemeQuery;

    public BottomLineOverlayPainter(ColorSchemeSingleColorQuery colorSchemeQuery) {
        this.colorSchemeQuery = colorSchemeQuery;
    }

    @Override
    public void paintOverlay(Graphics2D graphics, Component comp, SubstanceSlices.DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        Component topMostWithSameDecorationAreaType = SubstanceCoreUtilities.getTopMostParentWithDecorationAreaType(comp, decorationAreaType);
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        graphics.setStroke(new BasicStroke(borderStrokeWidth));
        SubstanceColorScheme colorScheme = skin.getBackgroundColorScheme(decorationAreaType);
        graphics.setColor(this.colorSchemeQuery.query(colorScheme));
        float bottomY = (float)topMostWithSameDecorationAreaType.getHeight() - borderStrokeWidth;
        Line2D.Float line = new Line2D.Float(0.0f, bottomY, width, bottomY);
        graphics.draw(line);
    }

    @Override
    public String getDisplayName() {
        return "Bottom Line";
    }
}

