/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.painter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SeparatorPainterUtils {
    private static LazyResettableHashMap<BufferedImage> cached = new LazyResettableHashMap("SeparatorPainterUtils");

    public static void paintSeparator(Component c, Graphics graphics, int width, int height, int orientation) {
        SeparatorPainterUtils.paintSeparator(c, graphics, width, height, orientation, true, 10);
    }

    public static void paintSeparator(Component c, Graphics graphics, int width, int height, int orientation, boolean hasShadow, int maxGradLength) {
        SeparatorPainterUtils.paintSeparator(c, graphics, width, height, orientation, hasShadow, maxGradLength, maxGradLength, false);
    }

    public static void paintSeparator(Component c, Graphics g, int width, int height, int orientation, boolean hasShadow, int maxGradLengthStart, int maxGradLengthEnd, boolean toEnforceAlphaColors) {
        boolean isParentAPopup;
        SubstanceColorScheme compScheme = null;
        Container parent = c.getParent();
        boolean bl = isParentAPopup = parent instanceof JPopupMenu || parent instanceof JComponent && ((JComponent)parent).getClientProperty("substancelaf.internal.popupInvokerLink") != null;
        if (isParentAPopup && (compScheme = SubstanceColorSchemeUtilities.getDirectColorScheme(c, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED)) == null) {
            compScheme = SubstanceCoreUtilities.getSkin(c).getBackgroundColorScheme(SubstanceCortex.ComponentOrParentChainScope.getDecorationType(c));
        }
        if (compScheme == null) {
            compScheme = SubstanceColorSchemeUtilities.getColorScheme(c, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, ComponentState.ENABLED);
        }
        SeparatorPainterUtils.paintSeparator(c, g, compScheme, width, height, orientation, hasShadow, maxGradLengthStart, maxGradLengthEnd, toEnforceAlphaColors);
    }

    public static void paintSeparator(Component c, Graphics g, SubstanceColorScheme scheme, int width, int height, int orientation, boolean hasShadow, int maxGradLengthStart, int maxGradLengthEnd, boolean toEnforceAlphaColors) {
        SubstanceSlices.DecorationAreaType decorationAreaType = SubstanceCortex.ComponentOrParentChainScope.getDecorationType(c);
        SubstanceSkin skin = SubstanceCoreUtilities.getSkin(c);
        boolean toUseAlphaColors = decorationAreaType == null || decorationAreaType == SubstanceSlices.DecorationAreaType.NONE ? false : skin.isRegisteredAsDecorationArea(decorationAreaType) || skin.getOverlayPainters(decorationAreaType).size() > 0;
        toUseAlphaColors = toUseAlphaColors || toEnforceAlphaColors;
        Color backgrFill = SubstanceColorUtilities.getBackgroundFillColor(c);
        int fontSize = SubstanceSizeUtils.getComponentFontSize(c);
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        if (orientation == 0 && height == 0) {
            height = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        }
        if (orientation == 1 && width == 0) {
            width = (int)Math.ceil(2.0 * (double)borderStrokeWidth);
        }
        if (width == 0 || height == 0) {
            return;
        }
        HashMapKey key = SubstanceCoreUtilities.getHashKey(fontSize, scheme.getDisplayName(), width, height, orientation, hasShadow, maxGradLengthStart, maxGradLengthEnd, toUseAlphaColors, backgrFill.getRGB());
        BufferedImage singleLine = cached.get(key);
        if (singleLine == null) {
            singleLine = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D graphics = singleLine.createGraphics();
            Color foreLight = SeparatorPainterUtils.getSeparatorLightColor(scheme);
            Color foreDark = SeparatorPainterUtils.getSeparatorDarkColor(scheme);
            Color back = SeparatorPainterUtils.getSeparatorShadowColor(scheme);
            Color foreLight12 = toUseAlphaColors ? SubstanceColorUtilities.getAlphaColor(foreLight, 32) : SubstanceColorUtilities.getInterpolatedColor(foreLight, backgrFill, 0.12f);
            Color foreDark95 = toUseAlphaColors ? SubstanceColorUtilities.getAlphaColor(foreDark, 240) : SubstanceColorUtilities.getInterpolatedColor(foreDark, backgrFill, 0.95f);
            Color back12 = toUseAlphaColors ? SubstanceColorUtilities.getAlphaColor(back, 32) : SubstanceColorUtilities.getInterpolatedColor(back, backgrFill, 0.12f);
            Color back95 = toUseAlphaColors ? SubstanceColorUtilities.getAlphaColor(back, 240) : SubstanceColorUtilities.getInterpolatedColor(back, backgrFill, 0.95f);
            graphics.setStroke(new BasicStroke(borderStrokeWidth, 0, 1));
            if (orientation == 1) {
                int gradStart = Math.min(maxGradLengthStart, height / 2);
                int gradEnd = Math.min(maxGradLengthEnd, height / 2);
                float regularX = Math.max(0.0f, (float)width / 2.0f - borderStrokeWidth);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, foreLight12, 0.0f, gradStart, foreDark95));
                graphics.draw(new Line2D.Float(regularX, 0.0f, regularX, gradStart));
                graphics.setColor(foreDark95);
                graphics.draw(new Line2D.Float(regularX, gradStart, regularX, height - gradEnd));
                graphics.setPaint(new GradientPaint(0.0f, height - gradEnd, foreDark95, 0.0f, height, foreLight12));
                graphics.draw(new Line2D.Float(regularX, height - gradEnd, regularX, height));
                if (hasShadow) {
                    float shadowX = regularX + borderStrokeWidth;
                    graphics.setPaint(new GradientPaint(0.0f, 0.0f, back12, 0.0f, gradStart, back95));
                    graphics.draw(new Line2D.Float(shadowX, 0.0f, shadowX, gradStart));
                    graphics.setColor(back95);
                    graphics.draw(new Line2D.Float(shadowX, gradStart, shadowX, height - gradEnd));
                    graphics.setPaint(new GradientPaint(0.0f, height - gradEnd, back95, 0.0f, height, back12));
                    graphics.draw(new Line2D.Float(shadowX, height - gradEnd, shadowX, height));
                }
            } else {
                int gradStart = Math.min(maxGradLengthStart, width / 2);
                int gradEnd = Math.min(maxGradLengthEnd, width / 2);
                graphics.translate(0, Math.max(0, height / 2 - 1));
                float regularY = Math.max(0.0f, (float)height / 2.0f - borderStrokeWidth);
                graphics.setPaint(new GradientPaint(0.0f, 0.0f, foreLight12, gradStart, 0.0f, foreDark95));
                graphics.draw(new Line2D.Float(0.0f, regularY, gradStart, regularY));
                graphics.setColor(foreDark95);
                graphics.draw(new Line2D.Float(gradStart, regularY, width - gradEnd, regularY));
                graphics.setPaint(new GradientPaint(width - gradEnd, 0.0f, foreDark95, width, 0.0f, foreLight12));
                graphics.draw(new Line2D.Float(width - gradEnd, regularY, width, regularY));
                if (hasShadow) {
                    float shadowY = regularY + borderStrokeWidth;
                    graphics.setPaint(new GradientPaint(0.0f, 0.0f, back12, gradStart, 0.0f, back95));
                    graphics.draw(new Line2D.Float(0.0f, shadowY, gradStart, shadowY));
                    graphics.setColor(back95);
                    graphics.draw(new Line2D.Float(gradStart, shadowY, width - gradEnd, shadowY));
                    graphics.setPaint(new GradientPaint(width - gradEnd, 0.0f, back95, width, 0.0f, back12));
                    graphics.draw(new Line2D.Float(width - gradEnd, shadowY, width, shadowY));
                }
            }
            graphics.dispose();
            cached.put(key, singleLine);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        NeonCortex.drawImage(g2d, singleLine, 0, 0);
        g2d.dispose();
    }

    public static Color getSeparatorShadowColor(SubstanceColorScheme scheme) {
        return scheme.isDark() ? scheme.getDarkColor() : scheme.getUltraLightColor();
    }

    public static Color getSeparatorDarkColor(SubstanceColorScheme scheme) {
        return scheme.isDark() ? scheme.getExtraLightColor() : SubstanceColorUtilities.getInterpolatedColor(scheme.getMidColor(), scheme.getDarkColor(), 0.4f);
    }

    public static Color getSeparatorLightColor(SubstanceColorScheme scheme) {
        return scheme.isDark() ? scheme.getLightColor() : SubstanceColorUtilities.getInterpolatedColor(scheme.getLightColor(), scheme.getDarkColor(), 0.8f);
    }

    public static void paintVerticalLines(Graphics g, Component c, SubstanceColorScheme scheme, int y, Collection<Integer> x, int height, float fadeStartFraction) {
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize(c);
        Color backgrFill = SubstanceColorUtilities.getBackgroundFillColor(c);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(componentFontSize, scheme.getDisplayName(), 0, height, 1, true, 0.0, Float.valueOf(fadeStartFraction), backgrFill.getRGB());
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        BufferedImage singleLine = cached.get(key);
        if (singleLine == null) {
            singleLine = SubstanceCoreUtilities.getBlankImage(Math.max(2, (int)Math.ceil(2.0 * (double)borderStrokeWidth)), height);
            Graphics2D graphics = singleLine.createGraphics();
            Color foreLight = SeparatorPainterUtils.getSeparatorLightColor(scheme);
            Color foreDark = SeparatorPainterUtils.getSeparatorDarkColor(scheme);
            Color back = SeparatorPainterUtils.getSeparatorShadowColor(scheme);
            graphics.setStroke(new BasicStroke(borderStrokeWidth, 0, 1));
            Color foreLight12 = SubstanceColorUtilities.getInterpolatedColor(foreLight, backgrFill, 0.12f);
            Color foreDark95 = SubstanceColorUtilities.getInterpolatedColor(foreDark, backgrFill, 0.95f);
            Color back12 = SubstanceColorUtilities.getInterpolatedColor(back, backgrFill, 0.12f);
            Color back95 = SubstanceColorUtilities.getInterpolatedColor(back, backgrFill, 0.95f);
            LinearGradientPaint forePaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{foreDark95, foreDark95, foreLight12});
            graphics.setPaint(forePaint);
            graphics.translate(borderStrokeWidth / 2.0f, 0.0);
            graphics.draw(new Line2D.Float(borderStrokeWidth / 2.0f, 0.0f, borderStrokeWidth / 2.0f, height));
            LinearGradientPaint backPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{back95, back95, back12});
            graphics.setPaint(backPaint);
            graphics.draw(new Line2D.Float(3.0f * borderStrokeWidth / 2.0f, 0.0f, 3.0f * borderStrokeWidth / 2.0f, height));
            graphics.dispose();
            cached.put(key, singleLine);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        for (int lineX : x) {
            NeonCortex.drawImage(g2d, singleLine, lineX, y);
        }
        g2d.dispose();
    }

    public static void paintHorizontalLines(Graphics g, Component c, SubstanceColorScheme scheme, int x, Collection<Integer> y, int width, float fadeStartFraction, boolean isLtr) {
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize(c);
        Color backgrFill = SubstanceColorUtilities.getBackgroundFillColor(c);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(componentFontSize, scheme.getDisplayName(), width, 0, 1, true, 0.0, Float.valueOf(fadeStartFraction), isLtr, backgrFill.getRGB());
        float borderStrokeWidth = SubstanceSizeUtils.getBorderStrokeWidth();
        BufferedImage singleLine = cached.get(key);
        if (singleLine == null) {
            singleLine = SubstanceCoreUtilities.getBlankImage(width, Math.max(2, (int)Math.ceil(2.0 * (double)borderStrokeWidth)));
            Graphics2D graphics = singleLine.createGraphics();
            Color foreLight = SeparatorPainterUtils.getSeparatorLightColor(scheme);
            Color foreDark = SeparatorPainterUtils.getSeparatorDarkColor(scheme);
            Color back = SeparatorPainterUtils.getSeparatorShadowColor(scheme);
            graphics.setStroke(new BasicStroke(borderStrokeWidth, 0, 1));
            Color foreLight12 = SubstanceColorUtilities.getInterpolatedColor(foreLight, backgrFill, 0.12f);
            Color foreDark95 = SubstanceColorUtilities.getInterpolatedColor(foreDark, backgrFill, 0.95f);
            Color back12 = SubstanceColorUtilities.getInterpolatedColor(back, backgrFill, 0.12f);
            Color back95 = SubstanceColorUtilities.getInterpolatedColor(back, backgrFill, 0.95f);
            LinearGradientPaint forePaint = new LinearGradientPaint(0.0f, 0.0f, width, 0.0f, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{isLtr ? foreDark95 : foreLight12, foreDark95, isLtr ? foreLight12 : foreDark95});
            graphics.setPaint(forePaint);
            graphics.draw(new Line2D.Float(0.0f, borderStrokeWidth / 2.0f, width, borderStrokeWidth / 2.0f));
            LinearGradientPaint backPaint = new LinearGradientPaint(0.0f, 9.0f, width, 0.0f, new float[]{0.0f, fadeStartFraction, 1.0f}, new Color[]{isLtr ? back95 : back12, back95, isLtr ? back12 : back95});
            graphics.setPaint(backPaint);
            graphics.draw(new Line2D.Float(0.0f, 3.0f * borderStrokeWidth / 2.0f, width, 3.0f * borderStrokeWidth / 2.0f));
            graphics.dispose();
            cached.put(key, singleLine);
        }
        Graphics2D g2d = (Graphics2D)g.create();
        for (int lineY : y) {
            NeonCortex.drawImage(g2d, singleLine, x, lineY);
        }
        g2d.dispose();
    }
}

