/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSliderUI;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.ClassicFillPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.painter.SeparatorPainterUtils;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.icon.SubstanceIconFactory;

public class SubstanceSliderUI
extends BasicSliderUI
implements TransitionAwareUI {
    private ButtonModel thumbModel = new DefaultButtonModel();
    private RolloverControlListener substanceRolloverListener;
    private PropertyChangeListener substancePropertyChangeListener;
    private StateTransitionTracker stateTransitionTracker;
    private Icon horizontalIcon;
    private Icon roundIcon;
    private Icon verticalIcon;
    private static final LazyResettableHashMap<BufferedImage> trackCache = new LazyResettableHashMap("SubstanceSliderUI.track");

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceSliderUI((JSlider)comp);
    }

    protected SubstanceSliderUI(JSlider slider) {
        super(null);
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        this.thumbModel.setEnabled(slider.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(slider, this.thumbModel);
    }

    @Override
    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.slider.getOrientation() != 0) {
            this.trackRect.x = this.slider.getComponentOrientation().isLeftToRight() ? (this.trackRect.x += 2) : (this.trackRect.x -= 2);
        }
    }

    private Rectangle getPaintTrackRect() {
        int trackLeft = 0;
        int trackRight = 0;
        int trackTop = 0;
        int trackBottom = 0;
        int trackWidth = this.getTrackWidth();
        if (this.slider.getOrientation() == 0) {
            trackRight = this.trackRect.width;
            if (this.slider.getPaintLabels() || this.slider.getPaintTicks()) {
                trackTop = 3 + this.insetCache.top + 2 * this.focusInsets.top;
            } else {
                int topInset = this.insetCache.top + this.focusInsets.top;
                int bottomInset = this.insetCache.bottom + this.focusInsets.bottom;
                trackTop = topInset + (this.slider.getHeight() - topInset - bottomInset) / 2 - trackWidth / 2;
            }
            trackBottom = trackTop + trackWidth - 1;
            return new Rectangle(this.trackRect.x + trackLeft, trackTop, trackRight - trackLeft, trackBottom - trackTop);
        }
        if (this.slider.getPaintLabels() || this.slider.getPaintTicks()) {
            if (this.slider.getComponentOrientation().isLeftToRight()) {
                trackLeft = this.trackRect.x + this.insetCache.left + this.focusInsets.left;
                trackRight = trackLeft + trackWidth - 1;
            } else {
                trackRight = this.trackRect.x + this.trackRect.width - this.insetCache.right - this.focusInsets.right;
                trackLeft = trackRight - trackWidth - 1;
            }
        } else {
            int leftInset = this.insetCache.left + this.focusInsets.left;
            int rightInset = this.insetCache.right + this.focusInsets.right;
            trackLeft = leftInset + (this.slider.getWidth() - leftInset - rightInset) / 2 - trackWidth / 2;
            trackRight = trackLeft + trackWidth - 1;
        }
        trackBottom = this.trackRect.height - 1;
        return new Rectangle(trackLeft, this.trackRect.y + trackTop, trackRight - trackLeft, trackBottom - trackTop);
    }

    @Override
    public void paintTrack(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        boolean drawInverted = this.drawInverted();
        Rectangle paintRect = this.getPaintTrackRect();
        int width = paintRect.width;
        int height = paintRect.height;
        if (this.slider.getOrientation() == 1) {
            int temp = width;
            width = height;
            height = temp;
            AffineTransform at = graphics.getTransform();
            at.translate(paintRect.x, width + paintRect.y);
            at.rotate(-1.5707963267948966);
            graphics.setTransform(at);
        } else {
            graphics.translate(paintRect.x, paintRect.y);
        }
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.stateTransitionTracker.getModelStateInfo();
        SubstanceColorScheme trackSchemeUnselected = SubstanceColorSchemeUtilities.getColorScheme(this.slider, this.slider.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme trackBorderSchemeUnselected = SubstanceColorSchemeUtilities.getColorScheme(this.slider, SubstanceSlices.ColorSchemeAssociationKind.BORDER, this.slider.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        this.paintSliderTrack(graphics, drawInverted, trackSchemeUnselected, trackBorderSchemeUnselected, width, height);
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float contribution;
            ComponentState activeState = activeEntry.getKey();
            if (!activeState.isActive() || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
            graphics.setComposite(WidgetUtilities.getAlphaComposite(this.slider, contribution, g));
            SubstanceColorScheme activeFillScheme = SubstanceColorSchemeUtilities.getColorScheme(this.slider, activeState);
            SubstanceColorScheme activeBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.slider, SubstanceSlices.ColorSchemeAssociationKind.BORDER, activeState);
            this.paintSliderTrackSelected(graphics, drawInverted, paintRect, activeFillScheme, activeBorderScheme, width, height);
        }
        graphics.dispose();
    }

    private void paintSliderTrack(Graphics2D graphics, boolean drawInverted, SubstanceColorScheme fillColorScheme, SubstanceColorScheme borderScheme, int width, int height) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        ClassicFillPainter fillPainter = ClassicFillPainter.INSTANCE;
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(this.slider);
        int componentFontSize = SubstanceSizeUtils.getComponentFontSize(this.slider);
        float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth() / 2.0f;
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(componentFontSize) / 2.0f;
        float borderThickness = (int)SubstanceSizeUtils.getBorderStrokeWidth();
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, Float.valueOf(radius), Float.valueOf(borderDelta), Float.valueOf(borderThickness), fillColorScheme.getDisplayName(), borderScheme.getDisplayName());
        BufferedImage trackImage = trackCache.get(key);
        if (trackImage == null) {
            trackImage = SubstanceCoreUtilities.getBlankImage(width + 1, height + 1);
            Graphics2D cacheGraphics = trackImage.createGraphics();
            GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(width + 1, height + 1, radius, null, borderDelta);
            fillPainter.paintContourBackground(cacheGraphics, this.slider, width, height, contour, false, fillColorScheme, false);
            GeneralPath contourInner = SubstanceOutlineUtilities.getBaseOutline(width + 1, height + 1, radius - borderThickness, null, borderThickness + borderDelta);
            borderPainter.paintBorder(cacheGraphics, this.slider, width + 1, height + 1, contour, contourInner, borderScheme);
            trackCache.put(key, trackImage);
            cacheGraphics.dispose();
        }
        NeonCortex.drawImage(graphics, trackImage, 0, 0);
        g2d.dispose();
    }

    private void paintSliderTrackSelected(Graphics2D graphics, boolean drawInverted, Rectangle paintRect, SubstanceColorScheme fillScheme, SubstanceColorScheme borderScheme, int width, int height) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        Insets insets = this.slider.getInsets();
        insets.top /= 2;
        insets.left /= 2;
        insets.bottom /= 2;
        insets.right /= 2;
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(this.slider);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(this.slider);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.slider)) / 2.0f;
        float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth() / 2.0f;
        if (this.slider.isEnabled()) {
            if (this.slider.getOrientation() == 0) {
                int fillMaxX;
                int fillMinX;
                int middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2 - paintRect.x;
                if (drawInverted) {
                    fillMinX = middleOfThumb;
                    fillMaxX = width;
                } else {
                    fillMinX = 0;
                    fillMaxX = middleOfThumb;
                }
                int fillWidth = fillMaxX - fillMinX;
                int fillHeight = height + 1;
                if (fillWidth > 0 && fillHeight > 0) {
                    GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(fillWidth, fillHeight, radius, null, borderDelta);
                    g2d.translate(fillMinX, 0);
                    fillPainter.paintContourBackground(g2d, this.slider, fillWidth, fillHeight, contour, false, fillScheme, false);
                    borderPainter.paintBorder(g2d, this.slider, fillWidth, fillHeight, contour, null, borderScheme);
                }
            } else {
                int fillMax;
                int fillMin;
                int middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2 - paintRect.y;
                if (this.drawInverted()) {
                    fillMin = 0;
                    fillMax = middleOfThumb;
                    g2d.translate(width + 2 - middleOfThumb, 0);
                } else {
                    fillMin = middleOfThumb;
                    fillMax = width + 1;
                }
                int fillWidth = fillMax - fillMin;
                int fillHeight = height + 1;
                if (fillWidth > 0 && fillHeight > 0) {
                    GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(fillWidth, fillHeight, radius, null, borderDelta);
                    fillPainter.paintContourBackground(g2d, this.slider, fillWidth, fillHeight, contour, false, fillScheme, false);
                    borderPainter.paintBorder(g2d, this.slider, fillWidth, fillHeight, contour, null, borderScheme);
                }
            }
        }
        g2d.dispose();
    }

    @Override
    protected Dimension getThumbSize() {
        Icon thumbIcon = this.getIcon();
        return new Dimension(thumbIcon.getIconWidth(), thumbIcon.getIconHeight());
    }

    protected Icon getIcon() {
        if (this.slider.getOrientation() == 0) {
            if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
                return this.horizontalIcon;
            }
            return this.roundIcon;
        }
        if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
            return this.verticalIcon;
        }
        return this.roundIcon;
    }

    @Override
    public void paintThumb(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        Rectangle knobBounds = this.thumbRect;
        graphics.translate(knobBounds.x, knobBounds.y);
        Icon icon = this.getIcon();
        if (this.slider.getOrientation() == 0) {
            if (icon != null) {
                graphics.translate(-2, 0);
                icon.paintIcon(this.slider, graphics, 0, 0);
            }
        } else if (this.slider.getComponentOrientation().isLeftToRight()) {
            if (icon != null) {
                graphics.translate(1, -1);
                icon.paintIcon(this.slider, graphics, 0, 0);
            }
        } else if (icon != null) {
            graphics.translate(1, 1);
            icon.paintIcon(this.slider, graphics, 0, 0);
        }
        graphics.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        ComponentState currState = ComponentState.getState(this.thumbModel, this.slider);
        float alpha = SubstanceColorSchemeUtilities.getAlpha(this.slider, currState);
        BackgroundPaintingUtils.updateIfOpaque(graphics, c);
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle clip = graphics.getClipBounds();
        if (!clip.intersects(this.trackRect) && this.slider.getPaintTrack()) {
            this.calculateGeometry();
        }
        graphics.setComposite(WidgetUtilities.getAlphaComposite(this.slider, alpha, g));
        if (this.slider.getPaintTrack() && clip.intersects(this.trackRect)) {
            this.paintTrack(graphics);
        }
        if (this.slider.getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        this.paintFocus(graphics);
        if (clip.intersects(this.thumbRect)) {
            this.paintThumb(graphics);
        }
        graphics.setComposite(WidgetUtilities.getAlphaComposite(this.slider, 1.0f, g));
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
        graphics.dispose();
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent me) {
        Rectangle thumbB = this.thumbRect;
        if (thumbB == null) {
            return false;
        }
        return thumbB.contains(me.getX(), me.getY());
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        Font f = slider.getFont();
        if (f == null || f instanceof UIResource) {
            slider.setFont(new FontUIResource(SubstanceCortex.GlobalScope.getFontPolicy().getFontSet(null).getControlFont()));
        }
        int size = SubstanceSizeUtils.getSliderIconSize(SubstanceSizeUtils.getComponentFontSize(slider));
        this.horizontalIcon = SubstanceIconFactory.getSliderHorizontalIcon(size, false);
        this.roundIcon = SubstanceIconFactory.getSliderRoundIcon(size);
        this.verticalIcon = SubstanceIconFactory.getSliderVerticalIcon(size, false);
        int focusIns = (int)Math.ceil(2.0 * (double)SubstanceSizeUtils.getFocusStrokeWidth());
        this.focusInsets = new Insets(focusIns, focusIns, focusIns, focusIns);
    }

    @Override
    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        this.substanceRolloverListener = new RolloverControlListener(this, this.thumbModel);
        slider.addMouseListener(this.substanceRolloverListener);
        slider.addMouseMotionListener(this.substanceRolloverListener);
        this.substancePropertyChangeListener = evt -> {
            if ("enabled".equals(evt.getPropertyName())) {
                this.thumbModel.setEnabled(slider.isEnabled());
            }
            if ("font".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(() -> slider.updateUI());
            }
        };
        this.slider.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.substanceRolloverListener);
        slider.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        slider.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
    }

    @Override
    public void paintFocus(Graphics g) {
        SubstanceCoreUtilities.paintFocus(g, this.slider, this.slider, this, null, null, 1.0f, SubstanceSizeUtils.getFocusStrokeWidth());
    }

    protected int getTrackWidth() {
        return SubstanceSizeUtils.getSliderTrackSize(SubstanceSizeUtils.getComponentFontSize(this.slider));
    }

    @Override
    protected int getTickLength() {
        return SubstanceSizeUtils.getSliderTickSize(SubstanceSizeUtils.getComponentFontSize(this.slider));
    }

    @Override
    public void paintTicks(Graphics g) {
        Rectangle tickBounds = this.tickRect;
        SubstanceColorScheme tickScheme = SubstanceColorSchemeUtilities.getColorScheme(this.slider, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, this.slider.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        if (this.slider.getOrientation() == 0) {
            int value;
            int xPos = 0;
            if (this.slider.getMinorTickSpacing() > 0 && this.slider.getMajorTickSpacing() > 0) {
                ArrayList<Integer> minorXs = new ArrayList<Integer>();
                for (value = this.slider.getMinimum() + this.slider.getMinorTickSpacing(); value < this.slider.getMaximum(); value += this.slider.getMinorTickSpacing()) {
                    int delta = value - this.slider.getMinimum();
                    if (delta % this.slider.getMajorTickSpacing() == 0) continue;
                    xPos = this.xPositionForValue(value);
                    minorXs.add(xPos - 1);
                }
                SeparatorPainterUtils.paintVerticalLines(g, this.slider, tickScheme, tickBounds.y, minorXs, tickBounds.height / 2, 0.75f);
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                ArrayList<Integer> majorXs = new ArrayList<Integer>();
                for (value = this.slider.getMinimum() + this.slider.getMajorTickSpacing(); value < this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    majorXs.add(xPos - 1);
                }
                SeparatorPainterUtils.paintVerticalLines(g, this.slider, tickScheme, tickBounds.y, majorXs, tickBounds.height, 0.75f);
            }
        } else {
            g.translate(tickBounds.x, 0);
            int value = this.slider.getMinimum() + this.slider.getMinorTickSpacing();
            int yPos = 0;
            boolean ltr = this.slider.getComponentOrientation().isLeftToRight();
            if (this.slider.getMinorTickSpacing() > 0) {
                ArrayList<Integer> minorYs = new ArrayList<Integer>();
                int offset = 0;
                if (!ltr) {
                    offset = tickBounds.width - tickBounds.width / 2;
                }
                while (value < this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    minorYs.add(yPos);
                    value += this.slider.getMinorTickSpacing();
                }
                SeparatorPainterUtils.paintHorizontalLines(g, this.slider, tickScheme, offset, minorYs, tickBounds.width / 2, ltr ? 0.75f : 0.25f, ltr);
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                ArrayList<Integer> majorYs = new ArrayList<Integer>();
                for (value = this.slider.getMinimum() + this.slider.getMajorTickSpacing(); value < this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                    yPos = this.yPositionForValue(value);
                    majorYs.add(yPos);
                }
                SeparatorPainterUtils.paintHorizontalLines(g, this.slider, tickScheme, 0, majorYs, tickBounds.width, ltr ? 0.75f : 0.25f, ltr);
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    @Override
    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.slider.getPaintTicks() ? this.getTickLength() : 0;
        } else {
            this.tickRect.width = this.slider.getPaintTicks() ? this.getTickLength() : 0;
            this.tickRect.x = this.slider.getComponentOrientation().isLeftToRight() ? this.trackRect.x + this.trackRect.width : this.trackRect.x - this.tickRect.width;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
        }
        if (this.slider.getPaintTicks()) {
            if (this.slider.getOrientation() == 0) {
                this.tickRect.y -= 3;
            } else {
                this.tickRect.x = this.slider.getComponentOrientation().isLeftToRight() ? (this.tickRect.x -= 2) : (this.tickRect.x += 2);
            }
        }
    }

    @Override
    protected void calculateLabelRect() {
        super.calculateLabelRect();
        if (this.slider.getOrientation() == 1 && !this.slider.getPaintTicks() && this.slider.getComponentOrientation().isLeftToRight()) {
            this.labelRect.x += 3;
        }
        if (this.slider.getOrientation() == 1) {
            this.labelRect.width = this.getHeightOfTallestLabel();
        }
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        Rectangle trackRect = this.getPaintTrackRect();
        if (this.slider.getOrientation() == 0) {
            int valuePosition = this.xPositionForValue(this.slider.getValue());
            double centerY = (double)trackRect.y + (double)trackRect.height / 2.0;
            this.thumbRect.y = (int)(centerY - (double)this.thumbRect.height / 2.0) + 1;
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2 + 1;
        } else {
            int valuePosition = this.yPositionForValue(this.slider.getValue());
            double centerX = (double)trackRect.x + (double)trackRect.width / 2.0;
            this.thumbRect.x = (int)(centerX - (double)this.thumbRect.width / 2.0);
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            d = new Dimension(this.getPreferredVerticalSize());
            d.width = this.insetCache.left + this.insetCache.right;
            d.width += this.focusInsets.left + this.focusInsets.right;
            d.width += this.trackRect.width;
            if (this.slider.getPaintTicks()) {
                d.width += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                d.width += this.getWidthOfWidestLabel();
            }
            d.width += 3;
        } else {
            d = new Dimension(this.getPreferredHorizontalSize());
            d.height = this.insetCache.top + this.insetCache.bottom;
            d.height += this.focusInsets.top + this.focusInsets.bottom;
            d.height += this.trackRect.height;
            if (this.slider.getPaintTicks()) {
                d.height += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                d.height += this.getHeightOfTallestLabel();
            }
            d.height += 6;
        }
        return d;
    }

    @Override
    public void setThumbLocation(int x, int y) {
        super.setThumbLocation(x, y);
        this.slider.repaint();
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return new Dimension(SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this.slider), 200, 1, 20, false), 21);
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return new Dimension(21, SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this.slider), 200, 1, 20, false));
    }
}

