/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.api.shaper.RectangularButtonShaper;
import org.pushingpixels.substance.api.shaper.StandardButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.ModificationAwareUI;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.PairwiseButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.trident.Timeline;

public class ButtonBackgroundDelegate {
    private static LazyResettableHashMap<BufferedImage> regularBackgrounds = new LazyResettableHashMap("ButtonBackgroundDelegate");

    private static BufferedImage getFullAlphaBackground(AbstractButton button, SubstanceButtonShaper shaper, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, int width, int height) {
        ModificationAwareUI modificationAwareUI;
        Timeline modificationTimeline;
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)button.getUI());
        StateTransitionTracker.ModelStateInfo modelStateInfo = transitionAwareUI.getTransitionTracker().getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        Set<SubstanceSlices.Side> straightSides = SubstanceCoreUtilities.getSides(button, "substancelaf.internal.buttonStraightSide");
        boolean isRoundButton = StandardButtonShaper.isRoundButton(button);
        float radius = 0.0f;
        if (shaper instanceof RectangularButtonShaper) {
            radius = ((RectangularButtonShaper)((Object)shaper)).getCornerRadius(button, 0.0f);
        }
        Set<SubstanceSlices.Side> openSides = SubstanceCoreUtilities.getSides(button, "substancelaf.internal.buttonOpenSide");
        boolean isContentAreaFilled = button.isContentAreaFilled();
        boolean isBorderPainted = button.isBorderPainted();
        SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(button, SubstanceSlices.ColorSchemeAssociationKind.BORDER, currState);
        if (button.getUI() instanceof ModificationAwareUI && (modificationTimeline = (modificationAwareUI = (ModificationAwareUI)((Object)button.getUI())).getModificationTimeline()) != null && modificationTimeline.getState() != Timeline.TimelineState.IDLE) {
            HashMapKey key2;
            BufferedImage layer2;
            SubstanceColorScheme colorScheme2 = SubstanceColorSchemeUtilities.YELLOW;
            SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.ORANGE;
            float cyclePos = modificationTimeline.getTimelinePosition();
            HashMapKey key1 = SubstanceCoreUtilities.getHashKey(width, height, colorScheme.getDisplayName(), baseBorderScheme.getDisplayName(), shaper.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), straightSides, openSides, button.getClass().getName(), isRoundButton, Float.valueOf(radius), isContentAreaFilled, isBorderPainted, SubstanceSizeUtils.getComponentFontSize(button));
            BufferedImage layer1 = regularBackgrounds.get(key1);
            if (layer1 == null) {
                layer1 = ButtonBackgroundDelegate.createBackgroundImage(button, shaper, fillPainter, borderPainter, width, height, colorScheme, baseBorderScheme, openSides, isContentAreaFilled, isBorderPainted);
                regularBackgrounds.put(key1, layer1);
            }
            if ((layer2 = regularBackgrounds.get(key2 = SubstanceCoreUtilities.getHashKey(width, height, colorScheme2.getDisplayName(), baseBorderScheme.getDisplayName(), shaper.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), straightSides, openSides, button.getClass().getName(), isRoundButton, Float.valueOf(radius), isContentAreaFilled, isBorderPainted, SubstanceSizeUtils.getComponentFontSize(button)))) == null) {
                layer2 = ButtonBackgroundDelegate.createBackgroundImage(button, shaper, fillPainter, borderPainter, width, height, colorScheme2, baseBorderScheme, openSides, isContentAreaFilled, isBorderPainted);
                regularBackgrounds.put(key2, layer2);
            }
            BufferedImage result = SubstanceCoreUtilities.getBlankUnscaledImage(layer1);
            Graphics2D g2d = result.createGraphics();
            if (cyclePos < 1.0f) {
                g2d.drawImage(layer1, 0, 0, layer1.getWidth(), layer1.getHeight(), null);
            }
            if (cyclePos > 0.0f) {
                g2d.setComposite(AlphaComposite.SrcOver.derive(cyclePos));
                g2d.drawImage(layer2, 0, 0, layer2.getWidth(), layer2.getHeight(), null);
            }
            g2d.dispose();
            return result;
        }
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        SubstanceColorScheme baseFillScheme = SubstanceColorSchemeUtilities.getColorScheme(button, currState);
        HashMapKey keyBase = SubstanceCoreUtilities.getHashKey(width, height, baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), shaper.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), straightSides, openSides, button.getClass().getName(), isRoundButton, (int)(1000.0f * radius), isContentAreaFilled, isBorderPainted, SubstanceSizeUtils.getComponentFontSize(button));
        BufferedImage layerBase = regularBackgrounds.get(keyBase);
        if (layerBase == null) {
            layerBase = ButtonBackgroundDelegate.createBackgroundImage(button, shaper, fillPainter, borderPainter, width, height, baseFillScheme, baseBorderScheme, openSides, isContentAreaFilled, isBorderPainted);
            regularBackgrounds.put(keyBase, layerBase);
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return layerBase;
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankUnscaledImage(layerBase);
        Graphics2D g2d = result.createGraphics();
        g2d.drawImage(layerBase, 0, 0, layerBase.getWidth(), layerBase.getHeight(), null);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            SubstanceColorScheme fillScheme = SubstanceColorSchemeUtilities.getColorScheme(button, activeState);
            SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(button, SubstanceSlices.ColorSchemeAssociationKind.BORDER, activeState);
            HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, fillScheme.getDisplayName(), borderScheme.getDisplayName(), shaper.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), straightSides, openSides, button.getClass().getName(), isRoundButton, (int)(1000.0f * radius), isContentAreaFilled, isBorderPainted, SubstanceSizeUtils.getComponentFontSize(button));
            BufferedImage layer = regularBackgrounds.get(key);
            if (layer == null) {
                layer = ButtonBackgroundDelegate.createBackgroundImage(button, shaper, fillPainter, borderPainter, width, height, fillScheme, borderScheme, openSides, isContentAreaFilled, isBorderPainted);
                regularBackgrounds.put(key, layer);
            }
            g2d.drawImage(layer, 0, 0, layer.getWidth(), layer.getHeight(), null);
        }
        g2d.dispose();
        return result;
    }

    private static BufferedImage createBackgroundImage(AbstractButton button, SubstanceButtonShaper shaper, SubstanceFillPainter fillPainter, SubstanceBorderPainter borderPainter, int width, int height, SubstanceColorScheme colorScheme, SubstanceColorScheme borderScheme, Set<SubstanceSlices.Side> openSides, boolean isContentAreaFilled, boolean isBorderPainted) {
        int openDelta = (int)Math.ceil(3.0 * (double)SubstanceSizeUtils.getBorderStrokeWidth());
        openDelta = (int)((double)openDelta * NeonCortex.getScaleFactor());
        int deltaLeft = openSides != null && openSides.contains((Object)SubstanceSlices.Side.LEFT) ? openDelta : 0;
        int deltaRight = openSides != null && openSides.contains((Object)SubstanceSlices.Side.RIGHT) ? openDelta : 0;
        int deltaTop = openSides != null && openSides.contains((Object)SubstanceSlices.Side.TOP) ? openDelta : 0;
        int deltaBottom = openSides != null && openSides.contains((Object)SubstanceSlices.Side.BOTTOM) ? openDelta : 0;
        float borderDelta = SubstanceSizeUtils.getBorderStrokeWidth() / 2.0f;
        Shape contour = shaper.getButtonOutline(button, borderDelta, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, false);
        BufferedImage newBackground = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D finalGraphics = (Graphics2D)newBackground.getGraphics();
        finalGraphics.translate(-deltaLeft, -deltaTop);
        if (isContentAreaFilled) {
            fillPainter.paintContourBackground(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, false, colorScheme, true);
        }
        if (isBorderPainted) {
            float borderThickness = SubstanceSizeUtils.getBorderStrokeWidth();
            Shape contourInner = borderPainter.isPaintingInnerContour() ? shaper.getButtonOutline(button, borderDelta + borderThickness, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, true) : null;
            borderPainter.paintBorder(finalGraphics, button, width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, contourInner, borderScheme);
        }
        return newBackground;
    }

    public void updateBackground(Graphics g, AbstractButton button) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (SubstanceCoreUtilities.isButtonNeverPainted(button)) {
            return;
        }
        int width = button.getWidth();
        int height = button.getHeight();
        int y = 0;
        if (SubstanceCoreUtilities.isScrollButton(button) || SubstanceCoreUtilities.isSpinnerButton(button)) {
            PairwiseButtonBackgroundDelegate.updatePairwiseBackground(g, button, width, height, false);
            return;
        }
        SubstanceFillPainter fillPainter = SubstanceCoreUtilities.getFillPainter(button);
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(button);
        BufferedImage bgImage = ButtonBackgroundDelegate.getFullAlphaBackground(button, shaper, fillPainter, borderPainter, width, height);
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)button.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        boolean isFlat = SubstanceCoreUtilities.hasFlatAppearance(button);
        boolean isSpecial = isFlat || !button.isEnabled();
        float extraAlpha = 1.0f;
        if (isSpecial) {
            if (isFlat) {
                extraAlpha = 0.0f;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    ComponentState activeState = activeEntry.getKey();
                    if (activeState.isDisabled() || activeState == ComponentState.ENABLED) continue;
                    extraAlpha += activeEntry.getValue().getContribution();
                }
            } else if (!button.isEnabled()) {
                extraAlpha = SubstanceColorSchemeUtilities.getAlpha(button, modelStateInfo.getCurrModelState());
            }
        }
        if (extraAlpha > 0.0f) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setComposite(WidgetUtilities.getAlphaComposite(button, extraAlpha, g));
            NeonCortex.drawImage(graphics, bgImage, 0, y);
            graphics.dispose();
        }
    }

    public static boolean contains(AbstractButton button, int x, int y) {
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return false;
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(button);
        if (shaper == null) {
            return false;
        }
        Shape contour = shaper.getButtonOutline(button, 0.0f, button.getWidth(), button.getHeight(), false);
        return contour.contains(x, y);
    }

    static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceBackgroundDelegate: \n");
        sb.append("\t" + regularBackgrounds.size() + " regular");
        return sb.toString();
    }
}

