/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.CellRendererPane;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceColorUtilities {
    public static Color getTopBorderColor(SubstanceColorScheme scheme) {
        return scheme.getUltraDarkColor();
    }

    public static Color getMidBorderColor(SubstanceColorScheme scheme) {
        return scheme.getDarkColor();
    }

    public static Color getBottomBorderColor(SubstanceColorScheme scheme) {
        return SubstanceColorUtilities.getInterpolatedColor(scheme.getDarkColor(), scheme.getMidColor(), 0.5);
    }

    public static Color getTopFillColor(SubstanceColorScheme scheme) {
        return SubstanceColorUtilities.getInterpolatedColor(scheme.getDarkColor(), scheme.getMidColor(), 0.4);
    }

    public static Color getMidFillColor(SubstanceColorScheme scheme) {
        return scheme.getMidColor();
    }

    public static Color getBottomFillColor(SubstanceColorScheme scheme) {
        return scheme.getUltraLightColor();
    }

    public static Color getTopShineColor(SubstanceColorScheme scheme) {
        return SubstanceColorUtilities.getBottomFillColor(scheme);
    }

    public static Color getBottomShineColor(SubstanceColorScheme scheme) {
        return scheme.getLightColor();
    }

    public static int getInterpolatedRGB(Color color1, Color color2, double color1Likeness) {
        if (color1Likeness < 0.0 || color1Likeness > 1.0) {
            throw new IllegalArgumentException("Color likeness should be in 0.0-1.0 range [is " + color1Likeness + "]");
        }
        int alpha1 = color1.getAlpha();
        int alpha2 = color2.getAlpha();
        int r = SubstanceColorUtilities.getInterpolatedChannelValue(color1.getRed(), color2.getRed(), color1Likeness);
        int g = SubstanceColorUtilities.getInterpolatedChannelValue(color1.getGreen(), color2.getGreen(), color1Likeness);
        int b = SubstanceColorUtilities.getInterpolatedChannelValue(color1.getBlue(), color2.getBlue(), color1Likeness);
        int a = alpha1 == alpha2 ? alpha1 : (int)Math.round(color1Likeness * (double)alpha1 + (1.0 - color1Likeness) * (double)alpha2);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int getInterpolatedChannelValue(int value1, int value2, double value1Likeness) {
        double optical2;
        if (value1 == value2) {
            return value1;
        }
        if (value1Likeness == 1.0) {
            return value1;
        }
        if (value1Likeness == 0.0) {
            return value2;
        }
        double optical1 = SubstanceColorUtilities.EOCF_sRGB((float)value1 / 255.0f);
        double interpolatedOptical = value1Likeness * optical1 + (1.0 - value1Likeness) * (optical2 = SubstanceColorUtilities.EOCF_sRGB((float)value2 / 255.0f));
        double interpolatedElectro = SubstanceColorUtilities.OECF_sRGB(interpolatedOptical);
        int result = (int)Math.round(interpolatedElectro * 255.0);
        if (result < 0) {
            result = 0;
        }
        if (result > 255) {
            result = 255;
        }
        return result;
    }

    private static double OECF_sRGB(double linear) {
        return linear <= (double)0.0031308f ? linear * (double)12.92f : Math.pow(linear, 0.4166666567325592) * (double)1.055f - (double)0.055f;
    }

    private static double EOCF_sRGB(double srgb) {
        return srgb <= (double)0.04045f ? srgb / (double)12.92f : Math.pow((srgb + (double)0.055f) / (double)1.055f, 2.4f);
    }

    public static Color getInterpolatedColor(Color color1, Color color2, double color1Likeness) {
        if (color1.equals(color2)) {
            return color1;
        }
        if (color1Likeness == 1.0) {
            return color1;
        }
        if (color1Likeness == 0.0) {
            return color2;
        }
        return new Color(SubstanceColorUtilities.getInterpolatedRGB(color1, color2, color1Likeness), true);
    }

    public static Color invertColor(Color color) {
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue(), color.getAlpha());
    }

    public static int getNegativeColor(int rgb) {
        int transp = rgb >>> 24 & 0xFF;
        int r = rgb >>> 16 & 0xFF;
        int g = rgb >>> 8 & 0xFF;
        int b = rgb >>> 0 & 0xFF;
        return transp << 24 | 255 - r << 16 | 255 - g << 8 | 255 - b;
    }

    public static Color getAlphaColor(Color color, int alpha) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public static Color getSaturatedColor(Color color, double factor) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        if (red == green || green == blue) {
            return color;
        }
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(red, green, blue, hsbvals);
        float sat = hsbvals[1];
        sat = factor > 0.0 ? (sat += (float)factor * (1.0f - sat)) : (sat += (float)factor * sat);
        return new Color(Color.HSBtoRGB(hsbvals[0], sat, hsbvals[2]));
    }

    public static Color getHueShiftedColor(Color color, double hueShift) {
        float[] hsbvals = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsbvals);
        float hue = hsbvals[0];
        hue = (float)((double)hue + hueShift);
        if ((double)hue < 0.0) {
            hue = (float)((double)hue + 1.0);
        }
        if ((double)hue > 1.0) {
            hue = (float)((double)hue - 1.0);
        }
        return new Color(Color.HSBtoRGB(hue, hsbvals[1], hsbvals[2]));
    }

    public static Color deriveByBrightness(Color original, Color brightnessSource) {
        float[] hsbvalsOrig = new float[3];
        Color.RGBtoHSB(original.getRed(), original.getGreen(), original.getBlue(), hsbvalsOrig);
        float[] hsbvalsBrightnessSrc = new float[3];
        Color.RGBtoHSB(brightnessSource.getRed(), brightnessSource.getGreen(), brightnessSource.getBlue(), hsbvalsBrightnessSrc);
        return new Color(Color.HSBtoRGB(hsbvalsOrig[0], hsbvalsOrig[1], (hsbvalsBrightnessSrc[2] + hsbvalsOrig[2]) / 2.0f));
    }

    public static ColorUIResource getForegroundColor(SubstanceColorScheme scheme) {
        return new ColorUIResource(scheme.getForegroundColor());
    }

    public static Color getLighterColor(Color color, double diff) {
        return SubstanceColorUtilities.getInterpolatedColor(color, Color.white, 1.0 - diff);
    }

    public static Color getDarkerColor(Color color, double diff) {
        return SubstanceColorUtilities.getInterpolatedColor(color, Color.black, 1.0 - diff);
    }

    public static int getColorBrightness(int rgb) {
        int oldR = rgb >>> 16 & 0xFF;
        int oldG = rgb >>> 8 & 0xFF;
        int oldB = rgb >>> 0 & 0xFF;
        return (2126 * oldR + 7152 * oldG + 722 * oldB) / 10000;
    }

    public static Color getFocusColor(Component comp, TransitionAwareUI transitionAwareUI) {
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(comp, SubstanceSlices.ColorSchemeAssociationKind.MARK, currState);
        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            return colorScheme.getFocusRingColor();
        }
        float aggrRed = 0.0f;
        float aggrGreen = 0.0f;
        float aggrBlue = 0.0f;
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            ComponentState activeState = activeEntry.getKey();
            float alpha = activeEntry.getValue().getContribution();
            SubstanceColorScheme activeColorScheme = SubstanceColorSchemeUtilities.getColorScheme(comp, SubstanceSlices.ColorSchemeAssociationKind.MARK, activeState);
            Color activeForeground = activeColorScheme.getFocusRingColor();
            aggrRed += alpha * (float)activeForeground.getRed();
            aggrGreen += alpha * (float)activeForeground.getGreen();
            aggrBlue += alpha * (float)activeForeground.getBlue();
        }
        return new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
    }

    public static float getColorStrength(Color color) {
        return (float)Math.max(SubstanceColorUtilities.getColorBrightness(color.getRGB()), SubstanceColorUtilities.getColorBrightness(SubstanceColorUtilities.getNegativeColor(color.getRGB()))) / 255.0f;
    }

    public static Color getMarkColor(SubstanceColorScheme colorScheme, boolean isEnabled) {
        if (colorScheme.isDark()) {
            return SubstanceColorUtilities.getInterpolatedColor(colorScheme.getForegroundColor(), colorScheme.getUltraLightColor(), 0.9);
        }
        Color color1 = isEnabled ? colorScheme.getForegroundColor() : colorScheme.getUltraDarkColor();
        Color color2 = isEnabled ? colorScheme.getUltraDarkColor() : colorScheme.getLightColor();
        return SubstanceColorUtilities.getInterpolatedColor(color1, color2, 0.7);
    }

    public static Color getForegroundColor(Component component, StateTransitionTracker.ModelStateInfo modelStateInfo) {
        AbstractButton button;
        ComponentState currState = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        if (component instanceof AbstractButton && (SubstanceCoreUtilities.isButtonNeverPainted(button = (AbstractButton)component) || !button.isContentAreaFilled() || button instanceof JRadioButton || button instanceof JCheckBox)) {
            if (!currState.isDisabled()) {
                currState = ComponentState.ENABLED;
                activeStates = null;
            } else {
                currState = ComponentState.DISABLED_UNSELECTED;
                activeStates = null;
            }
        }
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, currState);
        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            return colorScheme.getForegroundColor();
        }
        float aggrRed = 0.0f;
        float aggrGreen = 0.0f;
        float aggrBlue = 0.0f;
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            ComponentState activeState = activeEntry.getKey();
            float alpha = activeEntry.getValue().getContribution();
            SubstanceColorScheme activeColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, activeState);
            Color activeForeground = activeColorScheme.getForegroundColor();
            aggrRed += alpha * (float)activeForeground.getRed();
            aggrGreen += alpha * (float)activeForeground.getGreen();
            aggrBlue += alpha * (float)activeForeground.getBlue();
        }
        return new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
    }

    public static Color getMenuComponentForegroundColor(JMenuItem menuComponent, StateTransitionTracker.ModelStateInfo modelStateInfo) {
        ComponentState currState = modelStateInfo.getCurrModelStateNoSelection();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        SubstanceSlices.ColorSchemeAssociationKind currAssocKind = SubstanceSlices.ColorSchemeAssociationKind.FILL;
        if (!currState.isDisabled() && currState != ComponentState.ENABLED) {
            currAssocKind = SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT;
        }
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(menuComponent, currAssocKind, currState);
        if (currState.isDisabled() || activeStates == null || activeStates.size() == 1) {
            return colorScheme.getForegroundColor();
        }
        float aggrRed = 0.0f;
        float aggrGreen = 0.0f;
        float aggrBlue = 0.0f;
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            ComponentState activeState = activeEntry.getKey();
            float alpha = activeEntry.getValue().getContribution();
            SubstanceSlices.ColorSchemeAssociationKind assocKind = SubstanceSlices.ColorSchemeAssociationKind.FILL;
            if (!activeState.isDisabled() && activeState != ComponentState.ENABLED) {
                assocKind = SubstanceSlices.ColorSchemeAssociationKind.HIGHLIGHT;
            }
            SubstanceColorScheme activeColorScheme = SubstanceColorSchemeUtilities.getColorScheme(menuComponent, assocKind, activeState);
            Color activeForeground = activeColorScheme.getForegroundColor();
            aggrRed += alpha * (float)activeForeground.getRed();
            aggrGreen += alpha * (float)activeForeground.getGreen();
            aggrBlue += alpha * (float)activeForeground.getBlue();
        }
        return new Color((int)aggrRed, (int)aggrGreen, (int)aggrBlue);
    }

    public static Color getBackgroundFillColor(Component component) {
        if (component instanceof JCheckBox || component instanceof JRadioButton || component instanceof JSlider) {
            component = component.getParent();
        } else if (!(!(component instanceof JTextComponent) || component.isOpaque() && ((JTextComponent)component).isEditable())) {
            component = component.getParent();
        }
        Color backgr = component.getBackground();
        if (SwingUtilities.getAncestorOfClass(CellRendererPane.class, component) != null) {
            return backgr;
        }
        boolean isBackgroundUiResource = backgr instanceof UIResource;
        if (!isBackgroundUiResource) {
            if (SubstanceCoreUtilities.getColorizationFactor(component) == 1.0 && component.isEnabled()) {
                return backgr;
            }
            SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(component, component.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
            backgr = scheme.getBackgroundFillColor();
        } else {
            ComponentState state = component.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            JTextComponent matchingTextComp = SubstanceCoreUtilities.getTextComponentForTransitions(component);
            if (matchingTextComp != null) {
                component = matchingTextComp;
                boolean isEditable = matchingTextComp.isEditable();
                if (!isEditable) {
                    return SubstanceColorUtilities.getBackgroundFillColor(component.getParent());
                }
            }
            if (component instanceof JMenuItem) {
                state = ComponentState.ENABLED;
            }
            backgr = SubstanceColorUtilities.getDefaultBackgroundColor(component, state);
            float alpha = SubstanceColorSchemeUtilities.getAlpha(component, state);
            if (alpha < 1.0f) {
                ColorUIResource defaultColor = SubstanceColorUtilities.getDefaultBackgroundColor(component, ComponentState.ENABLED);
                backgr = SubstanceColorUtilities.getInterpolatedColor(backgr, defaultColor, 1.0f - (1.0f - alpha) / 2.0f);
            }
        }
        return backgr;
    }

    public static Color getBackgroundFillColorScrollBar(JScrollBar scrollbar) {
        float alpha;
        ComponentState state = scrollbar.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        Color backgr = SubstanceColorUtilities.getDefaultBackgroundColor(scrollbar, state);
        if (state.isDisabled() && (alpha = SubstanceColorSchemeUtilities.getAlpha(scrollbar, state)) < 1.0f) {
            ColorUIResource defaultColor = SubstanceColorUtilities.getDefaultBackgroundColor(scrollbar, ComponentState.ENABLED);
            backgr = SubstanceColorUtilities.getInterpolatedColor(backgr, defaultColor, 1.0f - (1.0f - alpha) / 2.0f);
        }
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(scrollbar, state);
        backgr = SubstanceColorUtilities.getInterpolatedColor(backgr, SubstanceColorUtilities.getAlphaColor(colorScheme.getForegroundColor(), backgr.getAlpha()), 0.9);
        return backgr;
    }

    public static ColorUIResource getDefaultBackgroundColor(boolean toTreatAsTextComponent, SubstanceSkin skin, boolean isDisabled) {
        if (toTreatAsTextComponent || isDisabled) {
            return new ColorUIResource(skin.getEnabledColorScheme(SubstanceSlices.DecorationAreaType.NONE).getTextBackgroundFillColor());
        }
        return new ColorUIResource(skin.getEnabledColorScheme(SubstanceSlices.DecorationAreaType.NONE).getBackgroundFillColor());
    }

    public static ColorUIResource getDefaultBackgroundColor(Component comp, ComponentState compState) {
        if (comp instanceof JTextComponent) {
            return new ColorUIResource(SubstanceColorSchemeUtilities.getColorScheme(comp, compState).getTextBackgroundFillColor());
        }
        return new ColorUIResource(SubstanceCortex.ComponentScope.getCurrentSkin(comp).getBackgroundColorScheme(SubstanceCortex.ComponentOrParentChainScope.getDecorationType(comp)).getBackgroundFillColor());
    }

    public static Color getStripedBackground(JComponent component, int rowIndex) {
        Color backgr = SubstanceColorUtilities.getBackgroundFillColor(component);
        if (backgr == null) {
            return null;
        }
        if (rowIndex % 2 == 0) {
            return backgr;
        }
        double coef = 0.92;
        if (!component.isEnabled()) {
            coef = 1.0 - (1.0 - coef) / 2.0;
        }
        return SubstanceColorUtilities.getDarkerColor(backgr, 1.0 - coef);
    }

    public static String encode(int number) {
        if (number < 0 || number > 255) {
            throw new IllegalArgumentException("" + number);
        }
        String hex = "0123456789ABCDEF";
        char c1 = hex.charAt(number / 16);
        char c2 = hex.charAt(number % 16);
        return c1 + "" + c2;
    }

    public static String encode(Color color) {
        return "#" + SubstanceColorUtilities.encode(color.getRed()) + SubstanceColorUtilities.encode(color.getGreen()) + SubstanceColorUtilities.encode(color.getBlue());
    }
}

