/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.substance.internal.ui.SubstanceSplitPaneUI;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;
import org.pushingpixels.substance.internal.utils.icon.TransitionAwareIcon;

public class SubstanceSplitPaneDivider
extends BasicSplitPaneDivider
implements TransitionAwareUI {
    private RolloverControlListener substanceRolloverListener;
    protected StateTransitionTracker stateTransitionTracker;
    private PropertyChangeListener substancePropertyChangeListener;
    private ButtonModel gripModel;

    public SubstanceSplitPaneDivider(SubstanceSplitPaneUI ui) {
        super(ui);
        this.setLayout(new SubstanceDividerLayout());
    }

    @Override
    public void setBasicSplitPaneUI(BasicSplitPaneUI newUI) {
        if (this.splitPane != null) {
            this.uninstall();
        }
        if (newUI != null) {
            this.splitPane = newUI.getSplitPane();
            this.gripModel = new DefaultButtonModel();
            this.gripModel.setArmed(false);
            this.gripModel.setSelected(false);
            this.gripModel.setPressed(false);
            this.gripModel.setRollover(false);
            this.gripModel.setEnabled(this.splitPane.isEnabled());
            this.stateTransitionTracker = new StateTransitionTracker(this.splitPane, this.gripModel);
            this.substanceRolloverListener = new RolloverControlListener(this, this.gripModel);
            this.addMouseListener(this.substanceRolloverListener);
            this.addMouseMotionListener(this.substanceRolloverListener);
            this.substancePropertyChangeListener = evt -> {
                if ("enabled".equals(evt.getPropertyName())) {
                    boolean isEnabled = this.splitPane.isEnabled();
                    this.gripModel.setEnabled(isEnabled);
                    if (this.leftButton != null) {
                        this.leftButton.setEnabled(isEnabled);
                    }
                    if (this.rightButton != null) {
                        this.rightButton.setEnabled(isEnabled);
                    }
                    this.setEnabled(isEnabled);
                }
            };
            this.splitPane.addPropertyChangeListener(this.substancePropertyChangeListener);
            this.stateTransitionTracker.registerModelListeners();
        } else {
            this.uninstall();
        }
        super.setBasicSplitPaneUI(newUI);
    }

    private void uninstall() {
        this.removeMouseListener(this.substanceRolloverListener);
        this.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        if (this.substancePropertyChangeListener != null) {
            this.splitPane.removePropertyChangeListener(this.substancePropertyChangeListener);
            this.substancePropertyChangeListener = null;
        }
        this.stateTransitionTracker.unregisterModelListeners();
    }

    @Override
    public void paint(Graphics g) {
        if (SubstanceCoreUtilities.hasFlatAppearance(this.splitPane, true)) {
            BackgroundPaintingUtils.updateIfOpaque(g, this.splitPane);
        }
        Graphics2D graphics = (Graphics2D)g.create();
        StateTransitionTracker.ModelStateInfo modelStateInfo = this.stateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelState();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        float alpha = SubstanceColorSchemeUtilities.getAlpha(this.splitPane, currState);
        int minSizeForGripPresence = SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this), 30, 1, 2, false);
        int maxGripSize = SubstanceSizeUtils.getAdjustedSize(SubstanceSizeUtils.getComponentFontSize(this), 40, 1, 3, false);
        if (this.splitPane.getOrientation() == 1) {
            int thumbHeight = this.getHeight();
            if (thumbHeight >= minSizeForGripPresence) {
                int gripHeight = thumbHeight / 4;
                if (gripHeight > maxGripSize) {
                    gripHeight = maxGripSize;
                }
                int thumbWidth = this.getWidth();
                int gripX = 0;
                int gripY = (thumbHeight - gripHeight) / 2;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    float contribution = activeEntry.getValue().getContribution();
                    if (contribution == 0.0f) continue;
                    ComponentState activeState = activeEntry.getKey();
                    graphics.setComposite(WidgetUtilities.getAlphaComposite(this.splitPane, alpha * contribution, g));
                    SubstanceImageCreator.paintSplitDividerBumpImage(graphics, this, gripX, gripY, thumbWidth, gripHeight, false, SubstanceColorSchemeUtilities.getColorScheme(this, SubstanceSlices.ColorSchemeAssociationKind.MARK, activeState));
                }
            }
        } else {
            int thumbWidth = this.getWidth();
            if (thumbWidth >= minSizeForGripPresence) {
                int gripWidth = thumbWidth / 4;
                if (gripWidth > maxGripSize) {
                    gripWidth = maxGripSize;
                }
                int thumbHeight = this.getHeight();
                int gripX = (thumbWidth - gripWidth) / 2;
                int gripY = 1;
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    float contribution = activeEntry.getValue().getContribution();
                    if (contribution == 0.0f) continue;
                    ComponentState activeState = activeEntry.getKey();
                    graphics.setComposite(WidgetUtilities.getAlphaComposite(this.splitPane, alpha * contribution, g));
                    SubstanceImageCreator.paintSplitDividerBumpImage(graphics, this, gripX, gripY, gripWidth, thumbHeight, true, SubstanceColorSchemeUtilities.getColorScheme(this, SubstanceSlices.ColorSchemeAssociationKind.MARK, activeState));
                }
            }
        }
        graphics.dispose();
        super.paint(g);
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        SubstanceSplitPaneDividerButton oneTouchButton = new SubstanceSplitPaneDividerButton();
        TransitionAwareIcon verticalSplit = new TransitionAwareIcon(oneTouchButton, scheme -> {
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.splitPane);
            return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(fontSize), SubstanceSizeUtils.getSplitPaneArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 1, scheme);
        }, "substance.splitPane.left.vertical");
        TransitionAwareIcon horizontalSplit = new TransitionAwareIcon(oneTouchButton, scheme -> {
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.splitPane);
            return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(fontSize), SubstanceSizeUtils.getSplitPaneArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 7, scheme);
        }, "substance.splitPane.left.horizontal");
        oneTouchButton.setIcon(this.splitPane.getOrientation() == 0 ? verticalSplit : horizontalSplit);
        SubstanceCortex.ComponentOrParentScope.setButtonNeverPaintBackground(oneTouchButton, true);
        oneTouchButton.setRequestFocusEnabled(false);
        oneTouchButton.setCursor(Cursor.getPredefinedCursor(12));
        oneTouchButton.setFocusPainted(false);
        oneTouchButton.setBorderPainted(false);
        return oneTouchButton;
    }

    @Override
    protected JButton createRightOneTouchButton() {
        SubstanceSplitPaneDividerButton oneTouchButton = new SubstanceSplitPaneDividerButton();
        TransitionAwareIcon verticalSplit = new TransitionAwareIcon(oneTouchButton, scheme -> {
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.splitPane);
            return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(fontSize), SubstanceSizeUtils.getSplitPaneArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 5, scheme);
        }, "substance.splitPane.right.vertical");
        TransitionAwareIcon horizontalSplit = new TransitionAwareIcon(oneTouchButton, scheme -> {
            int fontSize = SubstanceSizeUtils.getComponentFontSize(this.splitPane);
            return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(fontSize), SubstanceSizeUtils.getSplitPaneArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 3, scheme);
        }, "substance.splitPane.right.horizontal");
        oneTouchButton.setIcon(this.splitPane.getOrientation() == 0 ? verticalSplit : horizontalSplit);
        SubstanceCortex.ComponentOrParentScope.setButtonNeverPaintBackground(oneTouchButton, true);
        oneTouchButton.setCursor(Cursor.getPredefinedCursor(12));
        oneTouchButton.setFocusPainted(false);
        oneTouchButton.setBorderPainted(false);
        oneTouchButton.setRequestFocusEnabled(false);
        return oneTouchButton;
    }

    public void updateOneTouchButtons(int orientation) {
        if (orientation == 0) {
            if (this.leftButton != null) {
                this.leftButton.setIcon(new TransitionAwareIcon(this.leftButton, scheme -> {
                    int fontSize = SubstanceSizeUtils.getComponentFontSize(this.splitPane);
                    return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(fontSize), SubstanceSizeUtils.getSplitPaneArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 1, scheme);
                }, "substance.splitPane.left.vertical"));
            }
            if (this.rightButton != null) {
                this.rightButton.setIcon(new TransitionAwareIcon(this.rightButton, scheme -> {
                    int fontSize = SubstanceSizeUtils.getComponentFontSize(this.splitPane);
                    return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(fontSize), SubstanceSizeUtils.getSplitPaneArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 5, scheme);
                }, "substance.splitPane.right.vertical"));
            }
        } else {
            if (this.leftButton != null) {
                this.leftButton.setIcon(new TransitionAwareIcon(this.leftButton, scheme -> {
                    int fontSize = SubstanceSizeUtils.getComponentFontSize(this.splitPane);
                    return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(fontSize), SubstanceSizeUtils.getSplitPaneArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 7, scheme);
                }, "substance.splitPane.left.horizontal"));
            }
            if (this.rightButton != null) {
                this.rightButton.setIcon(new TransitionAwareIcon(this.rightButton, scheme -> {
                    int fontSize = SubstanceSizeUtils.getComponentFontSize(this.splitPane);
                    return SubstanceImageCreator.getArrowIcon(SubstanceSizeUtils.getSplitPaneArrowIconWidth(fontSize), SubstanceSizeUtils.getSplitPaneArrowIconHeight(fontSize), SubstanceSizeUtils.getArrowStrokeWidth(fontSize) / 1.5f, 3, scheme);
                }, "substance.splitPane.right.horizontal"));
            }
        }
    }

    @Override
    public boolean isInside(MouseEvent me) {
        return true;
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    protected class SubstanceDividerLayout
    extends BasicSplitPaneDivider.DividerLayout {
        protected SubstanceDividerLayout() {
            super(SubstanceSplitPaneDivider.this);
        }

        @Override
        public void layoutContainer(Container c) {
            if (SubstanceSplitPaneDivider.this.leftButton != null && SubstanceSplitPaneDivider.this.rightButton != null && c == SubstanceSplitPaneDivider.this) {
                if (SubstanceSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = SubstanceSplitPaneDivider.this.getInsets();
                    int buttonWidth = ((SubstanceSplitPaneDivider)SubstanceSplitPaneDivider.this).leftButton.getPreferredSize().width;
                    int buttonHeight = ((SubstanceSplitPaneDivider)SubstanceSplitPaneDivider.this).leftButton.getPreferredSize().height;
                    int offset = SubstanceSizeUtils.getSplitPaneButtonOffset(SubstanceSizeUtils.getComponentFontSize(SubstanceSplitPaneDivider.this.splitPane));
                    if (SubstanceSplitPaneDivider.this.orientation == 0) {
                        int extraX = insets != null ? insets.left : 0;
                        int y = (c.getSize().height - buttonHeight) / 2;
                        SubstanceSplitPaneDivider.this.leftButton.setBounds(extraX + offset, y, buttonWidth, buttonHeight);
                        SubstanceSplitPaneDivider.this.rightButton.setBounds(SubstanceSplitPaneDivider.this.leftButton.getX() + SubstanceSplitPaneDivider.this.leftButton.getWidth(), y, buttonWidth, buttonHeight);
                    } else {
                        int extraY = insets != null ? insets.top : 0;
                        int x = (c.getSize().width - buttonWidth) / 2;
                        SubstanceSplitPaneDivider.this.leftButton.setBounds(x, extraY + offset, buttonWidth, buttonHeight);
                        SubstanceSplitPaneDivider.this.rightButton.setBounds(x, SubstanceSplitPaneDivider.this.leftButton.getY() + SubstanceSplitPaneDivider.this.leftButton.getHeight(), buttonWidth, buttonHeight);
                    }
                } else {
                    SubstanceSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    SubstanceSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }
    }

    private static class SubstanceSplitPaneDividerButton
    extends JButton {
        private SubstanceSplitPaneDividerButton() {
        }

        @Override
        public boolean isFocusable() {
            return false;
        }

        @Override
        public Insets getInsets() {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public Insets getInsets(Insets insets) {
            if (insets == null) {
                insets = new Insets(0, 0, 0, 0);
            }
            insets.set(0, 0, 0, 0);
            return insets;
        }

        @Override
        public Dimension getPreferredSize() {
            Insets bInsets = SubstanceSizeUtils.getButtonInsets(SubstanceSizeUtils.getComponentFontSize(this));
            int iconWidth = this.getIcon().getIconWidth();
            int iconHeight = this.getIcon().getIconHeight();
            return new Dimension(iconWidth + bInsets.left + bInsets.right, iconHeight + bInsets.top + bInsets.bottom);
        }
    }
}

