/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.border;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.SubstanceBorderPainter;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;

public class SubstanceTextComponentBorder
implements Border,
UIResource {
    protected Insets myInsets;
    private static LazyResettableHashMap<BufferedImage> smallImageCache = new LazyResettableHashMap("SubstanceTextComponentBorder");

    public SubstanceTextComponentBorder(Insets insets) {
        this.myInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    private void paintBorder(JComponent c, Graphics g, int x, int y, int width, int height, boolean isEnabled, boolean hasFocus) {
        TextUI ui;
        if (!SubstanceCoreUtilities.isCurrentLookAndFeel()) {
            return;
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        JTextComponent componentForTransitions = SubstanceCoreUtilities.getTextComponentForTransitions(c);
        boolean useCache = width * height < 100000;
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(c);
        if (componentForTransitions != null && (ui = componentForTransitions.getUI()) instanceof TransitionAwareUI) {
            TransitionAwareUI trackable = (TransitionAwareUI)((Object)ui);
            StateTransitionTracker stateTransitionTracker = trackable.getTransitionTracker();
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
            ComponentState currState = modelStateInfo.getCurrModelState();
            if (currState.isDisabled()) {
                currState = ComponentState.DISABLED_SELECTED;
            }
            graphics.translate(x, y);
            SubstanceColorScheme baseBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(componentForTransitions, SubstanceSlices.ColorSchemeAssociationKind.BORDER, currState);
            float baseAlpha = SubstanceColorSchemeUtilities.getAlpha(c, currState);
            graphics.setComposite(AlphaComposite.SrcOver.derive(baseAlpha));
            if (useCache) {
                HashMapKey baseHashKey = SubstanceCoreUtilities.getHashKey(borderPainter.getDisplayName(), width, height, baseBorderScheme.getDisplayName());
                BufferedImage baseLayer = smallImageCache.get(baseHashKey);
                if (baseLayer == null) {
                    baseLayer = SubstanceCoreUtilities.getBlankImage(width, height);
                    Graphics2D g2base = baseLayer.createGraphics();
                    SubstanceImageCreator.paintSimpleBorder(c, g2base, width, height, baseBorderScheme);
                    g2base.dispose();
                    smallImageCache.put(baseHashKey, baseLayer);
                }
                NeonCortex.drawImage(graphics, baseLayer, 0, 0);
            } else {
                SubstanceImageCreator.paintSimpleBorder(c, graphics, width, height, baseBorderScheme);
            }
            if (!currState.isDisabled() && activeStates.size() > 1) {
                for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                    float alpha;
                    float contribution;
                    ComponentState activeState = activeEntry.getKey();
                    if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f || (alpha = SubstanceColorSchemeUtilities.getAlpha(c, activeState)) == 0.0f) continue;
                    SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(componentForTransitions, SubstanceSlices.ColorSchemeAssociationKind.BORDER, activeState);
                    graphics.setComposite(AlphaComposite.SrcOver.derive(alpha * contribution));
                    if (useCache) {
                        HashMapKey extraHashKey = SubstanceCoreUtilities.getHashKey(borderPainter.getDisplayName(), width, height, borderScheme.getDisplayName());
                        BufferedImage extraLayer = smallImageCache.get(extraHashKey);
                        if (extraLayer == null) {
                            extraLayer = SubstanceCoreUtilities.getBlankImage(width, height);
                            Graphics2D g2extra = extraLayer.createGraphics();
                            SubstanceImageCreator.paintSimpleBorder(c, g2extra, width, height, baseBorderScheme);
                            g2extra.dispose();
                            smallImageCache.put(extraHashKey, extraLayer);
                        }
                        NeonCortex.drawImage(graphics, extraLayer, 0, 0);
                        continue;
                    }
                    SubstanceImageCreator.paintSimpleBorder(c, graphics, width, height, borderScheme);
                }
            }
            return;
        }
        ComponentState currState = isEnabled ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
        SubstanceColorScheme borderColorScheme = SubstanceColorSchemeUtilities.getColorScheme(c, SubstanceSlices.ColorSchemeAssociationKind.BORDER, currState);
        graphics.translate(x, y);
        if (useCache) {
            HashMapKey baseHashKey = SubstanceCoreUtilities.getHashKey(borderPainter.getDisplayName(), width, height, borderColorScheme.getDisplayName());
            BufferedImage baseLayer = smallImageCache.get(baseHashKey);
            if (baseLayer == null) {
                baseLayer = SubstanceCoreUtilities.getBlankImage(width, height);
                Graphics2D g2base = baseLayer.createGraphics();
                SubstanceImageCreator.paintSimpleBorder(c, g2base, width, height, borderColorScheme);
                g2base.dispose();
                smallImageCache.put(baseHashKey, baseLayer);
            }
            NeonCortex.drawImage(graphics, baseLayer, 0, 0);
        } else {
            SubstanceImageCreator.paintSimpleBorder(c, graphics, width, height, borderColorScheme);
        }
        graphics.dispose();
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        this.paintBorder((JComponent)c, g, x, y, width, height, c.isEnabled(), c.hasFocus());
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.myInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

