/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.widget.desktop;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import org.pushingpixels.neon.NeonCortex;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.internal.ui.SubstanceDesktopIconUI;
import org.pushingpixels.substance.internal.utils.ImageWrapperIcon;
import org.pushingpixels.substance.internal.utils.WidgetUtilities;

public class DesktopIconHoverPreviewWidget
extends SubstanceWidget<JInternalFrame.JDesktopIcon> {
    private JComponent compToHover;
    private PropertyChangeListener internalFramePropertyListener;
    private BufferedImage snapshot;
    private JWindow previewWindow;
    private boolean isInDrag;
    private TitleMouseHandler titleMouseHandler;

    @Override
    public void installComponents() {
        this.previewWindow = new JWindow();
        this.previewWindow.getContentPane().setLayout(new BorderLayout());
    }

    @Override
    public void installListeners() {
        this.internalFramePropertyListener = evt -> {
            if ("ancestor".equals(evt.getPropertyName())) {
                this.updateSnapshot(((JInternalFrame.JDesktopIcon)this.jcomp).getInternalFrame());
            }
        };
        ((JInternalFrame.JDesktopIcon)this.jcomp).getInternalFrame().addPropertyChangeListener(this.internalFramePropertyListener);
        this.titleMouseHandler = new TitleMouseHandler();
        SubstanceDesktopIconUI ui = (SubstanceDesktopIconUI)((JInternalFrame.JDesktopIcon)this.jcomp).getUI();
        this.compToHover = ui.getComponentForHover();
        if (this.compToHover != null) {
            this.compToHover.addMouseMotionListener(this.titleMouseHandler);
            this.compToHover.addMouseListener(this.titleMouseHandler);
        }
    }

    @Override
    public void uninstallListeners() {
        ((JInternalFrame.JDesktopIcon)this.jcomp).getInternalFrame().removePropertyChangeListener(this.internalFramePropertyListener);
        this.internalFramePropertyListener = null;
        if (this.compToHover != null) {
            this.compToHover.removeMouseMotionListener(this.titleMouseHandler);
            this.compToHover.removeMouseListener(this.titleMouseHandler);
        }
        this.titleMouseHandler = null;
    }

    private void syncPreviewWindow(boolean toShow) {
        if (toShow) {
            int x = ((JInternalFrame.JDesktopIcon)this.jcomp).getLocationOnScreen().x;
            int y = ((JInternalFrame.JDesktopIcon)this.jcomp).getLocationOnScreen().y;
            this.previewWindow.setLocation(x, y - this.previewWindow.getHeight());
        }
    }

    private void updateSnapshot(JInternalFrame frame) {
        if (!frame.isShowing()) {
            return;
        }
        int frameWidth = frame.getWidth();
        int frameHeight = frame.getHeight();
        int dx = 0;
        int dy = 0;
        Border internalFrameBorder = UIManager.getBorder("InternalFrame.border");
        Insets borderInsets = internalFrameBorder.getBorderInsets(frame);
        dx += borderInsets.left;
        dy += borderInsets.top;
        frameWidth -= borderInsets.left + borderInsets.right;
        frameHeight -= borderInsets.top + borderInsets.bottom;
        BasicInternalFrameUI frameUI = (BasicInternalFrameUI)frame.getUI();
        JComponent frameTitlePane = frameUI.getNorthPane();
        if (frameTitlePane != null) {
            dy += frameTitlePane.getHeight();
            frameHeight -= frameTitlePane.getHeight();
        }
        if (frameWidth > 0 && frameHeight > 0) {
            int maxWidth;
            BufferedImage tempCanvas = new BufferedImage(frameWidth, frameHeight, 2);
            Graphics tempCanvasGraphics = tempCanvas.getGraphics();
            tempCanvasGraphics.translate(-dx, -dy);
            HashMap<Component, Boolean> dbSnapshot = new HashMap<Component, Boolean>();
            WidgetUtilities.makePreviewable(frame, dbSnapshot);
            frame.paint(tempCanvasGraphics);
            WidgetUtilities.restorePreviewable(frame, dbSnapshot);
            int maxHeight = maxWidth = UIManager.getInt("DesktopIcon.width");
            double coef = Math.min((double)maxWidth / (double)frameWidth, (double)maxHeight / (double)frameHeight);
            if (coef < 1.0) {
                BufferedImage scaledDown;
                int sdWidth = (int)(coef * (double)frameWidth);
                this.snapshot = scaledDown = NeonCortex.createThumbnail(tempCanvas, sdWidth);
            } else {
                this.snapshot = tempCanvas;
            }
        }
    }

    protected class TitleMouseHandler
    extends MouseInputAdapter {
        protected TitleMouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (DesktopIconHoverPreviewWidget.this.isInDrag) {
                return;
            }
            BufferedImage previewImage = DesktopIconHoverPreviewWidget.this.snapshot;
            if (previewImage != null) {
                double scaleFactor = NeonCortex.getScaleFactor();
                DesktopIconHoverPreviewWidget.this.previewWindow.getContentPane().removeAll();
                JLabel previewLabel = new JLabel(new ImageWrapperIcon(previewImage));
                DesktopIconHoverPreviewWidget.this.previewWindow.getContentPane().add((Component)previewLabel, "Center");
                DesktopIconHoverPreviewWidget.this.previewWindow.setSize((int)((double)previewImage.getWidth() / scaleFactor), (int)((double)previewImage.getHeight() / scaleFactor));
                DesktopIconHoverPreviewWidget.this.syncPreviewWindow(true);
                DesktopIconHoverPreviewWidget.this.previewWindow.setVisible(true);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DesktopIconHoverPreviewWidget.this.isInDrag = false;
            DesktopIconHoverPreviewWidget.this.previewWindow.dispose();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            DesktopIconHoverPreviewWidget.this.previewWindow.dispose();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            DesktopIconHoverPreviewWidget.this.isInDrag = false;
            DesktopIconHoverPreviewWidget.this.syncPreviewWindow(true);
            DesktopIconHoverPreviewWidget.this.previewWindow.setVisible(true);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            DesktopIconHoverPreviewWidget.this.isInDrag = true;
            if (DesktopIconHoverPreviewWidget.this.previewWindow.isVisible()) {
                DesktopIconHoverPreviewWidget.this.syncPreviewWindow(false);
                DesktopIconHoverPreviewWidget.this.previewWindow.dispose();
            }
        }
    }
}

