/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.widget.text;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.pushingpixels.substance.api.SubstanceWidget;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.widget.text.LockBorder;

public class LockBorderWidget
extends SubstanceWidget<JTextComponent> {
    protected PropertyChangeListener propertyChangeListener;
    protected boolean isUninstalling = false;
    private static String ORIGINAL_BORDER = "substance.internal.originalBorder";

    @Override
    public void installListeners() {
        this.propertyChangeListener = evt -> {
            if ("border".equals(evt.getPropertyName())) {
                return;
            }
            if (ORIGINAL_BORDER.equals(evt.getPropertyName())) {
                return;
            }
            SwingUtilities.invokeLater(() -> {
                if (this.isUninstalling) {
                    return;
                }
                boolean hasLockIcon = LockBorderWidget.hasLockIcon(this.jcomp);
                if (hasLockIcon) {
                    this.installLockBorder();
                } else {
                    this.restoreOriginalBorder();
                }
            });
        };
        ((JTextComponent)this.jcomp).addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void uninstallListeners() {
        ((JTextComponent)this.jcomp).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    public void uninstallUI() {
        this.isUninstalling = true;
        Border original = (Border)((JTextComponent)this.jcomp).getClientProperty(ORIGINAL_BORDER);
        if (original != null) {
            ((JTextComponent)this.jcomp).setBorder(original);
        }
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        if (LockBorderWidget.hasLockIcon(this.jcomp)) {
            Border currBorder = ((JTextComponent)this.jcomp).getBorder();
            ((JTextComponent)this.jcomp).putClientProperty(ORIGINAL_BORDER, currBorder);
            ((JTextComponent)this.jcomp).setBorder(new LockBorder(currBorder));
        }
    }

    @Override
    public void uninstallDefaults() {
        this.isUninstalling = true;
        ((JTextComponent)this.jcomp).putClientProperty(ORIGINAL_BORDER, null);
    }

    private void installLockBorder() {
        if (((JTextComponent)this.jcomp).getClientProperty(ORIGINAL_BORDER) instanceof Border) {
            return;
        }
        Border currBorder = ((JTextComponent)this.jcomp).getBorder();
        if (currBorder != null) {
            ((JTextComponent)this.jcomp).putClientProperty(ORIGINAL_BORDER, currBorder);
            ((JTextComponent)this.jcomp).setBorder(new LockBorder(currBorder));
        }
    }

    private void restoreOriginalBorder() {
        if (((JTextComponent)this.jcomp).getClientProperty(ORIGINAL_BORDER) instanceof Border) {
            Border originalBorder = (Border)((JTextComponent)this.jcomp).getClientProperty(ORIGINAL_BORDER);
            ((JTextComponent)this.jcomp).setBorder(originalBorder);
            ((JTextComponent)this.jcomp).putClientProperty(ORIGINAL_BORDER, null);
        }
    }

    private static boolean hasLockIcon(Component comp) {
        boolean isEditableTextComponent;
        if (!SubstanceCoreUtilities.toShowExtraWidgets(comp)) {
            return false;
        }
        boolean bl = isEditableTextComponent = comp instanceof JTextComponent ? ((JTextComponent)comp).isEditable() : false;
        if (comp instanceof JComponent) {
            if (!isEditableTextComponent && Boolean.TRUE.equals(((JComponent)comp).getClientProperty("substancelaf.internal.widget.hasLockIcon"))) {
                return true;
            }
            if (Boolean.FALSE.equals(((JComponent)comp).getClientProperty("substancelaf.internal.widget.hasLockIcon"))) {
                return false;
            }
        }
        return !isEditableTextComponent && Boolean.TRUE.equals(UIManager.get("substancelaf.internal.widget.hasLockIcon"));
    }
}

