/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.weasis.launcher.ConfigData;
import org.weasis.launcher.Singleton;
import org.weasis.launcher.WeasisLauncher;

public class AppLauncher
extends WeasisLauncher
implements Singleton.SingletonApp {
    public AppLauncher(ConfigData configData) {
        super(configData);
    }

    public static void main(String[] argv) throws Exception {
        ConfigData configData = new ConfigData(argv);
        if (!Singleton.invoke(configData)) {
            AppLauncher instance = new AppLauncher(configData);
            Singleton.start(instance, configData.getSourceID());
            instance.launch(WeasisLauncher.Type.NATIVE);
        }
    }

    @Override
    public void newActivation(List<String> arguments) {
        this.waitWhenStarted();
        if (this.mTracker != null) {
            this.executeCommands(arguments, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWhenStarted() {
        AppLauncher appLauncher = this;
        synchronized (appLauncher) {
            int loop = 0;
            boolean runLoop = true;
            while (runLoop && !this.frameworkLoaded) {
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                    if (++loop <= 300) continue;
                    runLoop = false;
                }
                catch (InterruptedException e) {
                    runLoop = false;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public boolean canStartNewActivation(Properties prop) {
        boolean sameUser = this.configData.isPropertyValueSimilar("weasis.user", prop.getProperty("weasis.user"));
        boolean sameConfig = this.configData.isPropertyValueSimilar("weasis.config.hash", prop.getProperty("weasis.config.hash"));
        return sameUser && sameConfig;
    }

    @Override
    protected void stopSingletonServer() {
        Singleton.stop();
    }
}

