/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.startlevel.StartLevel;
import org.tukaani.xz.XZInputStream;
import org.weasis.launcher.FileUtil;
import org.weasis.launcher.Messages;
import org.weasis.launcher.Utils;
import org.weasis.launcher.WeasisLoader;

public class AutoProcessor {
    private static final Logger LOGGER = Logger.getLogger(FileUtil.class.getName());
    public static final String AUTO_DEPLOY_DIR_PROPERTY = "felix.auto.deploy.dir";
    public static final String AUTO_DEPLOY_DIR_VALUE = "bundle";
    public static final String AUTO_DEPLOY_ACTION_PROPERTY = "felix.auto.deploy.action";
    public static final String AUTO_DEPLOY_STARTLEVEL_PROPERTY = "felix.auto.deploy.startlevel";
    public static final String AUTO_DEPLOY_INSTALL_VALUE = "install";
    public static final String AUTO_DEPLOY_START_VALUE = "start";
    public static final String AUTO_DEPLOY_UPDATE_VALUE = "update";
    public static final String AUTO_DEPLOY_UNINSTALL_VALUE = "uninstall";
    public static final String AUTO_INSTALL_PROP = "felix.auto.install";
    public static final String AUTO_START_PROP = "felix.auto.start";
    public static final String XZ_COMPRESSION = ".xz";

    private AutoProcessor() {
    }

    public static void process(Map<String, String> configMap, Properties modulesi18n, BundleContext context, WeasisLoader weasisLoader) {
        HashMap<String, String> map = configMap == null ? new HashMap<String, String>() : configMap;
        AutoProcessor.processAutoDeploy(map, context, weasisLoader);
        AutoProcessor.processAutoProperties(map, modulesi18n, context, weasisLoader);
    }

    private static void processAutoDeploy(Map<String, String> configMap, BundleContext context, WeasisLoader weasisLoader) {
        String action = configMap.get(AUTO_DEPLOY_ACTION_PROPERTY);
        action = action == null ? "" : action;
        ArrayList<String> actionList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(action, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken().trim().toLowerCase();
            if (!s.equals(AUTO_DEPLOY_INSTALL_VALUE) && !s.equals(AUTO_DEPLOY_START_VALUE) && !s.equals(AUTO_DEPLOY_UPDATE_VALUE) && !s.equals(AUTO_DEPLOY_UNINSTALL_VALUE)) continue;
            actionList.add(s);
        }
        if (!actionList.isEmpty()) {
            Bundle b;
            int i;
            StartLevel sl = (StartLevel)context.getService(context.getServiceReference(StartLevel.class.getName()));
            int startLevel = sl.getInitialBundleStartLevel();
            if (configMap.get(AUTO_DEPLOY_STARTLEVEL_PROPERTY) != null) {
                try {
                    startLevel = Integer.parseInt(configMap.get(AUTO_DEPLOY_STARTLEVEL_PROPERTY));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            HashMap<String, Bundle> installedBundleMap = new HashMap<String, Bundle>();
            Bundle[] bundles = context.getBundles();
            for (int i2 = 0; i2 < bundles.length; ++i2) {
                installedBundleMap.put(bundles[i2].getLocation(), bundles[i2]);
            }
            String autoDir = configMap.get(AUTO_DEPLOY_DIR_PROPERTY);
            autoDir = autoDir == null ? AUTO_DEPLOY_DIR_VALUE : autoDir;
            Object[] files = new File(autoDir).listFiles();
            ArrayList<Object> jarList = new ArrayList<Object>();
            if (files != null) {
                Arrays.sort(files);
                for (int i3 = 0; i3 < files.length; ++i3) {
                    if (!((File)files[i3]).getName().endsWith(".jar")) continue;
                    jarList.add(files[i3]);
                }
            }
            weasisLoader.setMax(jarList.size());
            boolean cache = Boolean.TRUE.toString().equals(System.getProperty("http.bundle.cache", Boolean.TRUE.toString()));
            ArrayList<Bundle> startBundleList = new ArrayList<Bundle>();
            for (i = 0; i < jarList.size(); ++i) {
                File jar = (File)jarList.get(i);
                b = (Bundle)installedBundleMap.remove(jar.toURI().toString());
                try {
                    weasisLoader.writeLabel(WeasisLoader.LBL_DOWNLOADING + " " + jar.getName());
                    if (b == null && actionList.contains(AUTO_DEPLOY_INSTALL_VALUE)) {
                        b = AutoProcessor.installBundle(context, ((File)jarList.get(i)).toURI().toString(), cache);
                    } else if (b != null && actionList.contains(AUTO_DEPLOY_UPDATE_VALUE)) {
                        b.update();
                    }
                    if (b == null) continue;
                    weasisLoader.setValue(i + 1);
                    if (AutoProcessor.isFragment(b)) continue;
                    startBundleList.add(b);
                    sl.setBundleStartLevel(b, startLevel);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, ex, () -> String.format("Auto-deploy install %s", jar.getName()));
                    if ("onFirstInit".equals(configMap.get("org.osgi.framework.storage.clean"))) continue;
                    throw new IllegalStateException("A bundle cannot be started");
                }
            }
            if (actionList.contains(AUTO_DEPLOY_UNINSTALL_VALUE)) {
                for (Map.Entry entry : installedBundleMap.entrySet()) {
                    b = (Bundle)entry.getValue();
                    if (b.getBundleId() == 0L) continue;
                    try {
                        b.uninstall();
                    }
                    catch (BundleException ex) {
                        LOGGER.log(Level.SEVERE, ex, () -> String.format("Auto-deploy uninstall bundle %s", b.getSymbolicName()));
                    }
                }
            }
            if (actionList.contains(AUTO_DEPLOY_START_VALUE)) {
                for (i = 0; i < startBundleList.size(); ++i) {
                    Bundle b2 = (Bundle)startBundleList.get(i);
                    try {
                        b2.start();
                        continue;
                    }
                    catch (BundleException ex) {
                        LOGGER.log(Level.SEVERE, ex, () -> String.format("Auto-deploy install bundle %s", b2.getSymbolicName()));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processAutoProperties(Map<String, String> configMap, Properties modulesi18n, BundleContext context, WeasisLoader weasisLoader) {
        Bundle b;
        BundleElement bundle;
        String bundleName;
        StartLevel sl = (StartLevel)context.getService(context.getServiceReference(StartLevel.class.getName()));
        HashMap<String, BundleElement> bundleList = new HashMap<String, BundleElement>();
        Set<String> set = configMap.keySet();
        Iterator<String> item = set.iterator();
        while (item.hasNext()) {
            String key = item.next().toLowerCase();
            if (!key.startsWith(AUTO_INSTALL_PROP) && !key.startsWith(AUTO_START_PROP)) continue;
            int startLevel = sl.getInitialBundleStartLevel();
            try {
                startLevel = Integer.parseInt(key.substring(key.lastIndexOf(46) + 1));
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.SEVERE, ex, () -> String.format("Invalid start level %s", key));
            }
            boolean canBeStarted = key.startsWith(AUTO_START_PROP);
            StringTokenizer st = new StringTokenizer(configMap.get(key), "\" ", true);
            String location = AutoProcessor.nextLocation(st);
            while (location != null) {
                bundleName = AutoProcessor.getBundleNameFromLocation(location);
                if (!"System Bundle".equals(bundleName)) {
                    BundleElement b2 = new BundleElement(startLevel, location, canBeStarted);
                    bundleList.put(bundleName, b2);
                }
                location = AutoProcessor.nextLocation(st);
            }
        }
        weasisLoader.setMax(bundleList.size());
        HashMap<String, Bundle> installedBundleMap = new HashMap<String, Bundle>();
        Bundle[] bundles = context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            String bundleName2 = AutoProcessor.getBundleNameFromLocation(bundles[i].getLocation());
            if (bundleName2 == null) continue;
            try {
                BundleElement b3 = (BundleElement)bundleList.get(bundleName2);
                if (b3 == null) {
                    if ("System Bundle".equals(bundleName2)) continue;
                    bundles[i].uninstall();
                    LOGGER.log(Level.INFO, "Uninstall unused bundle: {0}", bundleName2);
                    continue;
                }
                if (bundles[i].getVersion().getQualifier().endsWith("SNAPSHOT")) {
                    bundles[i].uninstall();
                    LOGGER.log(Level.INFO, "Uninstall SNAPSHOT bundle: {0}", bundleName2);
                    continue;
                }
                installedBundleMap.put(bundleName2, bundles[i]);
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e, () -> String.format("Cannot remove from OSGI cache the bundle %s", bundleName2));
            }
        }
        boolean cache = Boolean.TRUE.toString().equals(System.getProperty("http.bundle.cache", Boolean.TRUE.toString()));
        int bundleIter = 0;
        for (Map.Entry element : bundleList.entrySet()) {
            bundleName = (String)element.getKey();
            bundle = (BundleElement)element.getValue();
            if (bundle == null) continue;
            try {
                weasisLoader.writeLabel(WeasisLoader.LBL_DOWNLOADING + " " + bundleName);
                b = (Bundle)installedBundleMap.get(bundleName);
                if (b == null) {
                    b = AutoProcessor.installBundle(context, bundle.getLocation(), cache);
                    installedBundleMap.put(bundleName, b);
                }
                sl.setBundleStartLevel(b, bundle.getStartLevel());
                AutoProcessor.loadTranslationBundle(context, b, installedBundleMap, modulesi18n);
            }
            catch (Exception ex) {
                if (bundleName.contains(System.getProperty("native.library.spec"))) {
                    LOGGER.log(Level.SEVERE, ex, () -> String.format("Cannot install a native bundle %s", bundleName));
                    continue;
                }
                LOGGER.log(Level.SEVERE, ex, () -> String.format("Cannot install bundle %s", bundleName));
                if ("onFirstInit".equals(configMap.get("org.osgi.framework.storage.clean"))) continue;
                throw new IllegalStateException("A bundle cannot be started");
            }
            finally {
                weasisLoader.setValue(++bundleIter);
            }
        }
        weasisLoader.writeLabel(Messages.getString("AutoProcessor.start"));
        for (Map.Entry element : bundleList.entrySet()) {
            bundleName = (String)element.getKey();
            bundle = (BundleElement)element.getValue();
            if (bundle == null || !bundle.isCanBeStarted()) continue;
            try {
                b = (Bundle)installedBundleMap.get(bundleName);
                if (b == null) {
                    b = AutoProcessor.installBundle(context, bundle.getLocation(), cache);
                }
                if (b == null) continue;
                b.start();
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, ex, () -> String.format("Cannot start bundle %s", bundleName));
            }
        }
    }

    static String getBundleNameFromLocation(String location) {
        if (location != null) {
            int index = location.lastIndexOf(47);
            String name = index >= 0 ? location.substring(index + 1) : location;
            index = name.lastIndexOf(".jar");
            return index >= 0 ? name.substring(0, index) : name;
        }
        return null;
    }

    private static void loadTranslationBundle(BundleContext context, Bundle b, Map<String, Bundle> installedBundleMap, Properties modulesi18n) {
        if (!modulesi18n.isEmpty() && b != null) {
            String baseURL;
            StringBuilder p = new StringBuilder(b.getSymbolicName());
            p.append("-i18n-");
            p.append("2.0.0");
            p.append(".jar");
            String filename = p.toString();
            String value = modulesi18n.getProperty(filename);
            if (value != null && (baseURL = System.getProperty("weasis.i18n")) != null) {
                String uri = baseURL + (baseURL.endsWith("/") ? filename : "/" + filename);
                String bundleName = AutoProcessor.getBundleNameFromLocation(filename);
                try {
                    Bundle b2 = installedBundleMap.get(bundleName);
                    if (b2 == null) {
                        b2 = context.installBundle(uri, FileUtil.getAdaptedConnection(new URI(uri).toURL(), false).getInputStream());
                        installedBundleMap.put(bundleName, b);
                    }
                    if (b2 != null && !value.equals(b2.getVersion().getQualifier())) {
                        if (b2.getLocation().startsWith(baseURL)) {
                            b2.update();
                        } else {
                            try {
                                b2.uninstall();
                                context.installBundle(uri, FileUtil.getAdaptedConnection(new URI(uri).toURL(), false).getInputStream());
                                installedBundleMap.put(bundleName, b);
                            }
                            catch (Exception exc) {
                                LOGGER.log(Level.SEVERE, exc, () -> String.format("Cannot install a translation bundle %s", uri));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e, () -> String.format("Cannot install a translation bundle %s", uri));
                }
            }
        }
    }

    private static String nextLocation(StringTokenizer st) {
        String retVal = null;
        if (st.countTokens() > 0) {
            String tokenList = "\" ";
            StringBuilder tokBuf = new StringBuilder(10);
            String tok = null;
            boolean inQuote = false;
            boolean tokStarted = false;
            boolean exit = false;
            while (st.hasMoreTokens() && !exit) {
                tok = st.nextToken(tokenList);
                if (tok.equals("\"")) {
                    boolean bl = inQuote = !inQuote;
                    if (inQuote) {
                        tokenList = "\"";
                        continue;
                    }
                    tokenList = "\" ";
                    continue;
                }
                if (tok.equals(" ")) {
                    if (!tokStarted) continue;
                    retVal = tokBuf.toString();
                    tokStarted = false;
                    tokBuf = new StringBuilder(10);
                    exit = true;
                    continue;
                }
                tokStarted = true;
                tokBuf.append(tok.trim());
            }
            if (!exit && tokStarted) {
                retVal = tokBuf.toString();
            }
            if (Utils.hasText(retVal)) {
                retVal = Utils.adaptPathToUri(retVal);
            }
        }
        return retVal;
    }

    private static boolean isFragment(Bundle bundle) {
        return bundle.getHeaders().get("Fragment-Host") != null;
    }

    private static Bundle installBundle(BundleContext context, String location, boolean httpCache) throws Exception {
        boolean pack = location.endsWith(XZ_COMPRESSION);
        if (pack) {
            boolean bl = pack = context.getBundle(location = location.substring(0, location.length() - 3)) == null;
        }
        if (pack) {
            Bundle bundle;
            URL url = new URL(location + XZ_COMPRESSION);
            XZInputStream xzStream = new XZInputStream(FileUtil.getAdaptedConnection(url, httpCache).getInputStream());
            try {
                bundle = context.installBundle(location, (InputStream)xzStream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        xzStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e, () -> String.format("Cannot install xz compressed bundle %s", url));
                }
            }
            xzStream.close();
            return bundle;
        }
        return context.installBundle(location, FileUtil.getAdaptedConnection(new URI(location).toURL(), httpCache).getInputStream());
    }

    static class BundleElement {
        private final int startLevel;
        private final String location;
        private final boolean canBeStarted;

        public BundleElement(int startLevel, String location, boolean canBeStarted) {
            this.startLevel = startLevel;
            this.location = location;
            this.canBeStarted = canBeStarted;
        }

        public int getStartLevel() {
            return this.startLevel;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean isCanBeStarted() {
            return this.canBeStarted;
        }
    }
}

