/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.Version;
import org.weasis.launcher.FileUtil;
import org.weasis.launcher.Utils;
import org.weasis.launcher.WeasisLauncher;

public class ConfigData {
    private static final Logger LOGGER = Logger.getLogger(ConfigData.class.getName());
    public static final String PARAM_CONFIG_URL = "wcfg";
    public static final String PARAM_ARGUMENT = "arg";
    public static final String PARAM_PROPERTY = "pro";
    public static final String PARAM_CODEBASE = "cdb";
    public static final String PARAM_CODEBASE_EXT = "cdb-ext";
    public static final String PARAM_AUTHORIZATION = "auth";
    private final List<String> arguments = new ArrayList<String>();
    private final Properties properties = new Properties();
    private final StringBuilder configOutput = new StringBuilder();
    private final Map<String, String> felixProps = new HashMap<String, String>();

    protected ConfigData() {
    }

    public ConfigData(String[] args) {
        this.init(args);
    }

    public void init(String[] args) {
        this.clear();
        LOGGER.log(Level.INFO, "Starting Weasis...");
        LOGGER.log(Level.INFO, "Initialization of the launch configuration...");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                LOGGER.log(Level.INFO, "Main arg {0} = {1}", new Object[]{Integer.toString(i), args[i]});
            }
            int index = Utils.getWeasisProtocolIndex(args);
            if (index < 0) {
                this.splitArgToCmd(args);
            } else {
                this.extractArgFromUri(args[index]);
                if (args.length > 1) {
                    ArrayList<String> otherArgs = new ArrayList<String>(args.length - 1);
                    for (int i = 0; i < args.length; ++i) {
                        if (i == index) continue;
                        otherArgs.add(args[i]);
                    }
                    this.splitArgToCmd(otherArgs.toArray(new String[otherArgs.size()]));
                }
            }
        }
        this.applyJavaProperties();
        this.applyConfigFromArguments();
        Properties felixConfig = this.loadConfigProperties();
        this.initWeasisProperties(felixConfig);
    }

    private void applyJavaProperties() {
        this.applyJavaProperty("felix.config.properties");
        this.applyJavaProperty("felix.extended.config.properties");
        for (String propertyName : System.getProperties().stringPropertyNames()) {
            if (!propertyName.startsWith("weasis.")) continue;
            this.applyJavaProperty(propertyName);
        }
    }

    private void applyJavaProperty(String key) {
        this.addProperty(key, System.getProperty(key));
    }

    public Map<String, String> getFelixProps() {
        return this.felixProps;
    }

    private void initWeasisProperties(Properties felixConfig) {
        ConfigData.setOsgiNativeLibSpecification();
        String profile = felixConfig.getProperty("weasis.profile", "default");
        this.addProperty("weasis.profile", profile);
        String name = felixConfig.getProperty("weasis.name", "Weasis");
        this.addProperty("weasis.name", name);
        String version = felixConfig.getProperty("weasis.version", "0.0.0");
        this.addProperty("weasis.version", version);
        String codebase = this.properties.getProperty("weasis.codebase.url");
        this.addProperty("weasis.source.id", ConfigData.toHex((codebase + profile).hashCode()));
        String user = this.properties.getProperty("weasis.user");
        if (!Utils.hasText(user)) {
            user = System.getProperty("user.name", "unknown");
            this.addProperty("weasis.user", user);
            this.addProperty("weasis.pref.local.session", Boolean.TRUE.toString());
        }
        this.addProperty("http.agent", name + "/" + version + " (" + System.getProperty("os.name") + "; " + System.getProperty("os.version") + "; " + System.getProperty("os.arch") + ")");
        String portable = this.properties.getProperty("weasis.portable.dir");
        if (portable != null) {
            LOGGER.log(Level.INFO, "Starting portable version");
            String pkey = "weasis.portable.dicom.directory";
            this.addProperty(pkey, felixConfig.getProperty(pkey, "dicom,DICOM,IMAGES,images"));
        }
        this.applyConfigToSystemProperties();
        this.filterConfigProperties(felixConfig);
        if (LOGGER.isLoggable(Level.FINEST)) {
            this.felixProps.forEach((k, v) -> LOGGER.log(Level.FINEST, () -> String.format("Felix config: %s = %s", k, v)));
        }
        File appFolder = new File(this.felixProps.get("org.osgi.framework.storage")).getParentFile();
        appFolder.mkdirs();
        this.addProperty("weasis.path", appFolder.getPath());
        System.setProperty("weasis.path", appFolder.getPath());
    }

    private void filterConfigProperties(Properties felixConfig) {
        String mvnRepo = System.getProperty("maven.localRepository", felixConfig.getProperty("maven.local.repo"));
        if (mvnRepo != null) {
            System.setProperty("maven.localRepository", Utils.adaptPathToUri(mvnRepo));
        }
        Enumeration<?> e = felixConfig.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            this.felixProps.put(name, Util.substVars((String)felixConfig.getProperty(name), (String)name, null, (Properties)felixConfig));
        }
    }

    private void extractArgFromUri(String uri) {
        try {
            String url = URLDecoder.decode(uri, "UTF-8");
            String[] cmds = url.split("\\$");
            if (cmds.length > 0) {
                for (int i = 1; i < cmds.length; ++i) {
                    if (i == cmds.length - 1 && cmds[i].endsWith("/")) {
                        cmds[i] = cmds[i].substring(0, cmds[i].length() - 1);
                    }
                    this.arguments.add(cmds[i]);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.log(Level.SEVERE, "Decoding weasis URI", e);
        }
    }

    private void applyConfigFromArguments() {
        List<String> configArgs = this.extractWeasisConfigArguments();
        this.applyConfigParams(this.getConfigParamsFromArgs(configArgs));
        this.applyConfigParams(this.getConfigParamsFromServicePath());
        String codeBaseUrl = this.properties.getProperty("weasis.codebase.url", "");
        if (!Utils.hasText(codeBaseUrl)) {
            this.applyLocalCodebase();
        }
        if (!this.properties.containsKey("felix.config.properties") && Utils.hasText(codeBaseUrl)) {
            String configProp = String.format("%s/%s/%s", codeBaseUrl, "conf", "config.properties");
            this.addProperty("felix.config.properties", configProp);
        }
        String codeBaseExtUrl = this.properties.getProperty("weasis.codebase.ext.url", "");
        if (!this.properties.containsKey("felix.extended.config.properties") && Utils.hasText(codeBaseExtUrl)) {
            String extConfigProp = String.format("%s/%s/%s", codeBaseExtUrl, "conf", "ext-config.properties");
            this.addProperty("felix.extended.config.properties", extConfigProp);
        }
        this.configOutput.append("\n  Application local codebase = ");
        this.configOutput.append(this.properties.getProperty("weasis.codebase.local"));
        this.configOutput.append("\n  Application codebase URL = ");
        this.configOutput.append(this.properties.getProperty("weasis.codebase.url"));
    }

    private String applyLocalCodebase() {
        File localCodebase = ConfigData.findLocalCodebase();
        String baseURI = localCodebase.toURI().toString();
        if (baseURI.endsWith("/")) {
            baseURI = baseURI.substring(0, baseURI.length() - 1);
        }
        try {
            this.addProperty("weasis.codebase.local", localCodebase.getAbsolutePath());
            this.addProperty("weasis.codebase.url", baseURI);
            baseURI = baseURI + "/conf/";
            this.addProperty("felix.config.properties", baseURI + "config.properties");
            this.addProperty("felix.extended.config.properties", baseURI + "ext-config.properties");
            this.addProperty("weasis.export.dicom", Boolean.TRUE.toString());
            this.addProperty("weasis.export.dicom.send", Boolean.TRUE.toString());
            this.addProperty("weasis.import.dicom", Boolean.TRUE.toString());
            this.addProperty("weasis.import.dicom.qr", Boolean.TRUE.toString());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Apply Codebase", e);
        }
        return baseURI;
    }

    private void applyConfigParams(Map<String, List<String>> configParams) {
        if (configParams == null) {
            return;
        }
        configParams.forEach((k, v) -> {
            switch (k) {
                case "wcfg": {
                    this.addProperty("weasis.config.url", (String)v.get(0));
                    break;
                }
                case "cdb": {
                    this.addProperty("weasis.codebase.url", (String)v.get(0));
                    break;
                }
                case "cdb-ext": {
                    this.addProperty("weasis.codebase.ext.url", (String)v.get(0));
                    break;
                }
                case "auth": {
                    this.addProperty("http.authorization", (String)v.get(0));
                    break;
                }
                case "pro": {
                    this.addProperties((Collection<String>)v);
                    break;
                }
                case "arg": {
                    this.addArguments((Collection<String>)v);
                    break;
                }
            }
        });
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    private void addArgument(String arg) {
        if (arg != null) {
            this.arguments.add(arg);
        }
    }

    private void addArguments(Collection<String> args) {
        if (args != null) {
            this.arguments.addAll(args);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void addProperty(String key, String val) {
        if (Utils.hasText(key) && Utils.hasText(val)) {
            this.properties.putIfAbsent(key, val);
        }
    }

    private void addProperties(Collection<String> properties) {
        Pattern pattern = Pattern.compile("\\s+");
        properties.forEach(value -> {
            String[] result = pattern.split((CharSequence)value, 2);
            if (result.length == 2) {
                this.addProperty(result[0], result[1]);
            } else {
                LOGGER.log(Level.WARNING, "Cannot parse property: {0}", value);
            }
        });
    }

    public StringBuilder getConfigOutput() {
        return this.configOutput;
    }

    public boolean isPropertyValueSimilar(String prop, String value) {
        String p = this.properties.getProperty(Objects.requireNonNull(prop));
        return Objects.equals(p, value);
    }

    public String getSourceID() {
        return this.properties.getProperty("weasis.source.id");
    }

    private void clear() {
        this.arguments.clear();
        this.properties.clear();
    }

    private void applyConfigToSystemProperties() {
        for (String key : this.properties.stringPropertyNames()) {
            System.setProperty(key, this.properties.getProperty(key));
        }
    }

    public void applyProxy(String dir) {
        File file = new File(dir, "persitence.properties");
        if (!file.canRead()) {
            return;
        }
        Properties p = new Properties();
        FileUtil.readProperties(file, p);
        boolean mproxy = Utils.getEmptytoFalse(p.getProperty("proxy.manual"));
        if (mproxy) {
            boolean auth;
            String exceptions = p.getProperty("proxy.exceptions");
            String val = p.getProperty("proxy.http.host");
            ConfigData.applyProxyProperty("http.proxyHost", val, mproxy);
            if (Utils.hasText(val)) {
                ConfigData.applyProxyProperty("http.proxyPort", p.getProperty("proxy.http.port"), mproxy);
                ConfigData.applyProxyProperty("http.nonProxyHosts", exceptions, mproxy);
            }
            val = p.getProperty("proxy.https.host");
            ConfigData.applyProxyProperty("https.proxyHost", val, mproxy);
            if (Utils.hasText(val)) {
                ConfigData.applyProxyProperty("https.proxyPort", p.getProperty("proxy.https.port"), mproxy);
                ConfigData.applyProxyProperty("http.nonProxyHosts", exceptions, mproxy);
            }
            val = p.getProperty("proxy.ftp.host");
            ConfigData.applyProxyProperty("ftp.proxyHost", val, mproxy);
            if (Utils.hasText(val)) {
                ConfigData.applyProxyProperty("ftp.proxyPort", p.getProperty("proxy.ftp.port"), mproxy);
                ConfigData.applyProxyProperty("ftp.nonProxyHosts", exceptions, mproxy);
            }
            val = p.getProperty("proxy.socks.host");
            ConfigData.applyProxyProperty("socksProxyHost", val, mproxy);
            if (Utils.hasText(val)) {
                ConfigData.applyProxyProperty("socksProxyPort", p.getProperty("proxy.socks.port"), mproxy);
            }
            if (auth = Utils.getEmptytoFalse(p.getProperty("proxy.auth"))) {
                String authUser = p.getProperty("proxy.auth.user");
                try {
                    byte[] pwd = Utils.getByteArrayProperty(p, "proxy.auth.pwd", null);
                    if (pwd != null && (pwd = Utils.decrypt(pwd, "proxy.auth")) != null && pwd.length > 0) {
                        String authPassword = new String(pwd);
                        ConfigData.applyPasswordAuthentication(authUser, authPassword);
                        ConfigData.applyProxyProperty("http.proxyUser", authUser, mproxy);
                        ConfigData.applyProxyProperty("http.proxyPassword", authPassword, mproxy);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Cannot store the proxy password", e);
                }
            }
        }
    }

    private static void applyPasswordAuthentication(final String authUser, final String authPassword) {
        Authenticator.setDefault(new Authenticator(){

            @Override
            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(authUser, authPassword.toCharArray());
            }
        });
    }

    private static void applyProxyProperty(String key, String value, boolean manual) {
        if (manual && Utils.hasText(value)) {
            System.setProperty(key, value);
        }
    }

    private void splitArgToCmd(String ... args) {
        int i;
        boolean files = true;
        int length = args.length;
        for (i = 0; i < length; ++i) {
            if (!args[i].startsWith("$") || args[i].length() <= 1) continue;
            files = false;
            StringBuilder command = new StringBuilder(args[i].substring(1));
            while (i + 1 < length && !args[i + 1].startsWith("$")) {
                command.append(' ');
                if (args[++i].indexOf(32) != -1 && !args[i].startsWith("\"")) {
                    command.append("\"");
                    command.append(args[i]);
                    command.append("\"");
                    continue;
                }
                command.append(args[i]);
            }
            this.arguments.add(command.toString());
        }
        if (files) {
            for (i = 0; i < args.length; ++i) {
                String val = args[i];
                if (val.startsWith("file:")) {
                    try {
                        val = new File(new URI(args[i])).getPath();
                    }
                    catch (URISyntaxException e) {
                        LOGGER.log(Level.SEVERE, "Convert URI to file", e);
                    }
                }
                this.arguments.add("dicom:get -l \"" + val + "\"");
            }
        }
    }

    private List<String> extractWeasisConfigArguments() {
        String configCmd = "weasis:config";
        for (String cmd : this.arguments) {
            if (!cmd.startsWith(configCmd) || cmd.length() <= configCmd.length() + 2) continue;
            this.arguments.remove(cmd);
            return Utils.splitSpaceExceptInQuotes(cmd.substring(configCmd.length() + 1));
        }
        return Collections.emptyList();
    }

    private Map<String, List<String>> getConfigParamsFromArgs(List<String> configArguments) {
        HashMap<String, List<String>> configParams = new HashMap<String, List<String>>();
        configArguments.forEach(a -> this.addConfigParam((Map<String, List<String>>)configParams, (String)a));
        return configParams;
    }

    private void addConfigParam(Map<String, List<String>> configParams, String argument) {
        if (argument == null) {
            return;
        }
        String[] vals = argument.split("=", 2);
        if (vals.length != 2) {
            return;
        }
        this.addConfigParam(configParams, vals[0], vals[1]);
    }

    private void addConfigParam(Map<String, List<String>> configParams, String name, String value) {
        if (!Utils.hasText(name) || value == null) {
            return;
        }
        List paramList = configParams.computeIfAbsent(name, p -> new LinkedList());
        paramList.add(Utils.removeEnglobingQuotes(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Map<String, List<String>> getConfigParamsFromServicePath() {
        String configServicePath = this.properties.getProperty("weasis.config.url");
        if (!Utils.hasText(configServicePath)) {
            return null;
        }
        InputStream stream = null;
        URI configServiceUri = new URI(configServicePath);
        if (configServiceUri.getScheme().startsWith("file")) {
            stream = new FileInputStream(new File(configServiceUri));
        } else {
            HttpURLConnection httpURLConnection;
            URLConnection urlConnection = FileUtil.getAdaptedConnection(new URI(configServicePath).toURL(), false);
            urlConnection.setRequestProperty("Accept", "application/xml");
            urlConnection.setConnectTimeout(Integer.valueOf(System.getProperty("UrlConnectionTimeout", "1000")));
            urlConnection.setReadTimeout(Integer.valueOf(System.getProperty("UrlReadTimeout", "2000")));
            if (urlConnection instanceof HttpURLConnection && (httpURLConnection = (HttpURLConnection)urlConnection).getResponseCode() != 200) {
                throw new IOException(httpURLConnection.getResponseMessage());
            }
            stream = urlConnection.getInputStream();
        }
        XMLStreamReader xmler = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        xmler = factory.createXMLStreamReader(stream);
        Map<String, List<String>> map = this.readServiceConfigStream(xmler);
        FileUtil.safeClose(xmler);
        FileUtil.safeClose(stream);
        return map;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        FileUtil.safeClose(xmler);
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, e, () -> String.format("Error Loading config service %s", configServicePath));
                        FileUtil.safeClose(stream);
                    }
                }
                catch (Throwable throwable2) {
                    FileUtil.safeClose(stream);
                    throw throwable2;
                }
            }
        }
        return null;
    }

    private Map<String, List<String>> readServiceConfigStream(XMLStreamReader xmler) throws XMLStreamException {
        HashMap<String, List<String>> configParams = new HashMap<String, List<String>>();
        while (xmler.hasNext()) {
            block0 : switch (xmler.next()) {
                case 1: {
                    switch (xmler.getLocalName()) {
                        case "property": {
                            String name = xmler.getAttributeValue(null, "name");
                            String value = xmler.getAttributeValue(null, "value");
                            this.addConfigParam(configParams, PARAM_PROPERTY, String.format("%s %s", name, value));
                            break block0;
                        }
                        case "argument": {
                            this.addConfigParam(configParams, PARAM_ARGUMENT, xmler.getElementText());
                        }
                    }
                }
            }
        }
        return configParams;
    }

    public Properties loadConfigProperties() {
        URI propURI = this.getPropertiesURI("felix.config.properties", "config.properties");
        Properties felixConfig = new Properties();
        if (propURI != null) {
            this.configOutput.append("\n  Application configuration file = ");
            this.configOutput.append(propURI);
            WeasisLauncher.readProperties(propURI, felixConfig);
        } else {
            LOGGER.log(Level.SEVERE, "No config.properties path found, Weasis cannot start!");
        }
        propURI = this.getPropertiesURI("felix.extended.config.properties", "ext-config.properties");
        if (propURI != null) {
            this.configOutput.append("\n  Application extension configuration file = ");
            this.configOutput.append(propURI);
            WeasisLauncher.readProperties(propURI, felixConfig);
        }
        this.checkMinimalVersion(felixConfig);
        if (felixConfig.isEmpty()) {
            throw new IllegalStateException("Cannot load weasis config!");
        }
        this.properties.put("weasis.config.hash", String.valueOf(felixConfig.hashCode()));
        return felixConfig;
    }

    private void checkMinimalVersion(Properties felixConfig) {
        String val = felixConfig.getProperty("weasis.min.native.version");
        if (Utils.hasText(val) && this.getProperty("weasis.codebase.local") == null) {
            try {
                URI propURI = this.getLocalPropertiesURI("felix.config.properties", "config.properties");
                Properties localProps = new Properties();
                WeasisLauncher.readProperties(propURI, localProps);
                Version loc = new Version(localProps.getProperty("weasis.version").replaceFirst("-", "."));
                Version min = new Version(val.replaceFirst("-", "."));
                if (loc.compareTo(min) < 0) {
                    felixConfig.clear();
                    felixConfig.putAll((Map<?, ?>)localProps);
                    propURI = this.getLocalPropertiesURI("felix.extended.config.properties", "ext-config.properties");
                    WeasisLauncher.readProperties(propURI, felixConfig);
                    System.setProperty("weasis.min.native.version", val);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Cannot check compatibility with remote package", e);
            }
        }
    }

    public URI getPropertiesURI(String configProp, String configFile) {
        URI propURL;
        String custom = this.properties.getProperty(configProp);
        if (Utils.hasText(custom)) {
            try {
                if (custom.startsWith("file:conf/")) {
                    propURL = new File(ConfigData.findLocalCodebase(), custom.substring(5)).toURI();
                }
                propURL = new URI(custom);
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.SEVERE, configProp, e);
                return null;
            }
        } else {
            propURL = this.getLocalPropertiesURI(configProp, configFile);
        }
        return propURL;
    }

    private URI getLocalPropertiesURI(String configProp, String configFile) {
        File confDir = new File(ConfigData.findLocalCodebase(), "conf");
        try {
            return new File(confDir, configFile).toURI();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, configFile, ex);
            return null;
        }
    }

    private static String toHex(int val) {
        char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] ch8 = new char[8];
        int i = 8;
        while (--i >= 0) {
            ch8[i] = hexDigit[val & 0xF];
            val >>= 4;
        }
        return String.valueOf(ch8);
    }

    static File findLocalCodebase() {
        String[] vals;
        String jarLocation = null;
        String classpath = System.getProperty("java.class.path");
        for (String cp : vals = classpath.split(File.pathSeparator)) {
            if (!cp.endsWith("weasis-launcher.jar")) continue;
            jarLocation = cp;
        }
        if (jarLocation == null) {
            return new File(ConfigData.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParentFile();
        }
        return new File(new File(jarLocation).getAbsolutePath()).getParentFile();
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public static void setOsgiNativeLibSpecification() {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        if (Utils.hasText(osName) && Utils.hasText(osArch)) {
            osName = osName.toLowerCase().startsWith("win") ? "windows" : (osName.equals("Mac OS X") ? "macosx" : (osName.equals("SymbianOS") ? "epoc32" : (osName.equals("hp-ux") ? "hpux" : (osName.equals("Mac OS") ? "macos" : (osName.equals("OS/2") ? "os2" : (osName.equals("procnto") ? "qnx" : osName.toLowerCase()))))));
            osArch = osArch.equals("pentium") || osArch.equals("i386") || osArch.equals("i486") || osArch.equals("i586") || osArch.equals("i686") ? "x86" : (osArch.equals("amd64") || osArch.equals("em64t") || osArch.equals("x86_64") ? "x86-64" : (osArch.equals("power ppc") ? "powerpc" : (osArch.equals("psc1k") ? "ignite" : osArch.toLowerCase())));
            System.setProperty("native.library.spec", osName + "-" + osArch);
        }
    }
}

