/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class ConsoleFormatter
extends Formatter {
    private static final MessageFormat messageFormat = new MessageFormat(System.getProperty("org.apache.sling.commons.log.pattern", "{0,date,dd.MM.yyyy HH:mm:ss.SSS} *{4}* [{2}] {3}: {5}") + "\n");

    @Override
    public String format(LogRecord record) {
        String format = record.getMessage();
        ResourceBundle catalog = record.getResourceBundle();
        if (catalog != null) {
            try {
                format = catalog.getString(format);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        try {
            Object[] parameters = record.getParameters();
            if (parameters == null || parameters.length == 0) {
                return ConsoleFormatter.getFinalFormat(record, format);
            }
            int index = -1;
            int fence = format.length() - 1;
            while ((index = format.indexOf(123, index + 1)) > -1 && index < fence) {
                char digit = format.charAt(index + 1);
                if (digit < '0' || digit > '9') continue;
                return ConsoleFormatter.getFinalFormat(record, MessageFormat.format(format, parameters));
            }
            return ConsoleFormatter.getFinalFormat(record, format);
        }
        catch (Exception ex) {
            return ConsoleFormatter.getFinalFormat(record, format);
        }
    }

    private static String getFinalFormat(LogRecord record, String message) {
        Object[] arguments = new Object[6];
        arguments[0] = new Date(record.getMillis());
        arguments[2] = Thread.currentThread().getName();
        arguments[3] = record.getLoggerName();
        arguments[4] = record.getLevel();
        arguments[5] = message;
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.print(messageFormat.format(arguments));
            record.getThrown().printStackTrace(pw);
            pw.close();
            return sw.toString();
        }
        return messageFormat.format(arguments);
    }
}

