/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.felix.framework.util.Util;
import org.weasis.launcher.Utils;

public class FileUtil {
    private static final Logger LOGGER = Logger.getLogger(FileUtil.class.getName());
    public static final int FILE_BUFFER = 4096;

    private FileUtil() {
    }

    public static void safeClose(AutoCloseable object) {
        if (object != null) {
            try {
                object.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot close AutoCloseable", e);
            }
        }
    }

    public static void safeClose(XMLStreamReader xmler) {
        if (xmler != null) {
            try {
                xmler.close();
            }
            catch (XMLStreamException e) {
                LOGGER.log(Level.WARNING, "Cannot close XMLStreamReader", e);
            }
        }
    }

    public static void recursiveDelete(File rootDir, boolean deleteRoot) {
        if (rootDir == null || !rootDir.isDirectory()) {
            return;
        }
        File[] childDirs = rootDir.listFiles();
        if (childDirs != null) {
            for (File f : childDirs) {
                if (f.isDirectory()) {
                    FileUtil.recursiveDelete(f, false);
                    FileUtil.deleteFile(f);
                    continue;
                }
                FileUtil.deleteFile(f);
            }
        }
        if (deleteRoot) {
            FileUtil.deleteFile(rootDir);
        }
    }

    public static final void deleteDirectoryContents(File dir, int deleteDirLevel, int level) {
        if (dir == null || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileUtil.deleteDirectoryContents(f, deleteDirLevel, level + 1);
                    continue;
                }
                FileUtil.deleteFile(f);
            }
        }
        if (level >= deleteDirLevel) {
            FileUtil.deleteFile(dir);
        }
    }

    private static boolean deleteFile(File fileOrDirectory) {
        try {
            Files.delete(fileOrDirectory.toPath());
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Cannot delete", e);
            return false;
        }
        return true;
    }

    public static boolean delete(File fileOrDirectory) {
        File[] files;
        if (fileOrDirectory == null || !fileOrDirectory.exists()) {
            return false;
        }
        if (fileOrDirectory.isDirectory() && (files = fileOrDirectory.listFiles()) != null) {
            for (File child : files) {
                FileUtil.delete(child);
            }
        }
        return FileUtil.deleteFile(fileOrDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(InputStream inputStream, OutputStream out) {
        if (inputStream == null || out == null) {
            return;
        }
        try {
            int offset;
            byte[] buf = new byte[4096];
            while ((offset = inputStream.read(buf)) > 0) {
                out.write(buf, 0, offset);
            }
            out.flush();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error when writing stream", e);
        }
        finally {
            FileUtil.safeClose(inputStream);
            FileUtil.safeClose(out);
        }
    }

    public static File getApplicationTempDir() {
        File tdir;
        String tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null || tempDir.length() == 1) {
            String dir = System.getProperty("user.home", "");
            tdir = new File(dir);
        } else {
            tdir = new File(tempDir);
        }
        return new File(tdir, "weasis-" + System.getProperty("user.name", "tmp"));
    }

    public static boolean readProperties(File propsFile, Properties props) {
        if (propsFile.canRead()) {
            boolean bl;
            FileInputStream fis = new FileInputStream(propsFile);
            try {
                props.load(fis);
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e, () -> String.format("Loading %s", propsFile.getPath()));
                }
            }
            fis.close();
            return bl;
        }
        return false;
    }

    public static void storeProperties(File propsFile, Properties props, String comments) {
        if (props != null && propsFile != null) {
            try (FileOutputStream fout = new FileOutputStream(propsFile);){
                props.store(fout, comments);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error when writing properties", e);
            }
        }
    }

    public static String writeResources(String srcPath, File cacheDir, String date) throws IOException {
        String fileDate = null;
        URLConnection urlConnection = FileUtil.getAdaptedConnection(new URL(srcPath), false);
        long last = urlConnection.getLastModified();
        if (last != 0L) {
            fileDate = Long.toString(last);
        }
        if (!cacheDir.canRead() || date == null || !date.equals(fileDate)) {
            FileUtil.recursiveDelete(cacheDir, false);
            FileUtil.unzip(urlConnection.getInputStream(), cacheDir);
        }
        return fileDate;
    }

    public static URLConnection getAdaptedConnection(URL url, boolean useCaches) throws IOException {
        String auth;
        URLConnection connection = url.openConnection();
        connection.setUseCaches(useCaches);
        String p = url.getProtocol();
        String pauth = System.getProperty("http.proxyAuth", null);
        if (Utils.hasText(pauth) && ("http".equals(p) || "https".equals(p))) {
            String base64 = Util.base64Encode((String)pauth);
            connection.setRequestProperty("Proxy-Authorization", "Basic " + base64);
        }
        if (Utils.hasText(auth = System.getProperty("http.authorization", null)) && ("http".equals(p) || "https".equals(p))) {
            connection.setRequestProperty("Authorization", auth);
        }
        return connection;
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int offset;
        if (in == null || out == null) {
            return;
        }
        byte[] buf = new byte[4096];
        while ((offset = in.read(buf)) > 0) {
            out.write(buf, 0, offset);
        }
        out.flush();
    }

    private static void copyZip(InputStream in, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            FileUtil.copy(in, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(InputStream inputStream, File directory) throws IOException {
        if (inputStream == null || directory == null) {
            return;
        }
        try (BufferedInputStream bufInStream = new BufferedInputStream(inputStream);
             ZipInputStream zis = new ZipInputStream(bufInStream);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(directory, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                FileUtil.copyZip(zis, file);
            }
        }
        finally {
            FileUtil.safeClose(inputStream);
        }
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        long absBytes;
        int unit = si ? 1000 : 1024;
        long l = absBytes = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absBytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(absBytes) / Math.log(unit));
        long th = (long)(Math.pow(unit, exp) * ((double)unit - 0.05));
        if (exp < 6 && absBytes >= th - (long)((th & 0xFFFL) == 3328L ? 52 : 0)) {
            ++exp;
        }
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        if (exp > 4) {
            bytes /= (long)unit;
            --exp;
        }
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static byte[] gzipUncompressToByte(byte[] bytes) throws IOException {
        if (FileUtil.isGzip(bytes)) {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                byte[] byArray;
                try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
                    FileUtil.gzipUncompress(inputStream, outputStream);
                    byArray = outputStream.toByteArray();
                }
                return byArray;
            }
        }
        return bytes;
    }

    public static boolean isGzip(byte[] bytes) {
        int head;
        return bytes != null && bytes.length >= 4 && 35615 == (head = bytes[0] & 0xFF | bytes[1] << 8 & 0xFF00);
    }

    private static boolean gzipUncompress(InputStream inputStream, OutputStream out) throws IOException {
        try (GZIPInputStream in = new GZIPInputStream(inputStream);){
            int offset;
            byte[] buf = new byte[1024];
            while ((offset = in.read(buf)) > 0) {
                out.write(buf, 0, offset);
            }
            boolean bl = true;
            return bl;
        }
    }
}

