/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.weasis.launcher.ConfigData;
import org.weasis.launcher.FileUtil;
import org.weasis.launcher.Utils;

public class Singleton {
    private static final Logger LOGGER = Logger.getLogger(Singleton.class.getName());
    private static final String LOCALHOST = "127.0.0.1";
    private static final File SI_FILEDIR = new File(System.getProperty("user.home") + File.separator + ".weasis", "singleton");
    private static final String SI_MAGICWORD = "si.init";
    private static final String SI_ARG = "si.arg";
    private static final String SI_PROP = "si.prop";
    private static final String SI_ACK = "si.ack";
    private static final String SI_EXIT = "si.exit";
    private static final String SI_STOP = "si.stop";
    private static final String SI_EOF = "si.EOF";
    private static final int ENCODING_PLATFORM = 1;
    private static final int ENCODING_UNICODE = 2;
    private static final String ENCODING_UNICODE_NAME = "UTF-16LE";
    private static int currPort;
    private static String stringId;
    private static String randomNumberString;
    private static SingletonServer siServer;
    private static SingletonApp siApp;
    private static final SecureRandom random;
    private static volatile boolean serverStarted;
    private static int randomNumber;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(SingletonApp sia, String id) {
        Objects.requireNonNull(sia);
        Objects.requireNonNull(id);
        Class<Singleton> clazz = Singleton.class;
        synchronized (Singleton.class) {
            if (!serverStarted) {
                try {
                    siServer = new SingletonServer(id);
                    siServer.start();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Create a Singleton serveur", e);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                siApp = sia;
                serverStarted = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop() {
        if (siApp == null) {
            LOGGER.log(Level.WARNING, "Singleton.stop() called when not running, id: {0}", stringId);
            return;
        }
        Class<Singleton> clazz = Singleton.class;
        synchronized (Singleton.class) {
            siApp = null;
            AccessController.doPrivileged(() -> {
                try (Socket socket = new Socket(LOCALHOST, siServer.getPort());
                     OutputStream os = socket.getOutputStream();
                     PrintStream out = new PrintStream(os, true, Charset.defaultCharset().name());){
                    byte[] encoding = new byte[]{1};
                    os.write(encoding);
                    out.println(randomNumber);
                    out.println(SI_STOP);
                    out.flush();
                    serverStarted = false;
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Stopping Singleton server", e);
                }
                return null;
            });
            siServer.runnable.removeSiFile();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean running(String id) {
        LOGGER.log(Level.FINE, "Check if another instance running for id: {0}", id);
        String[] fList = SI_FILEDIR.list();
        if (fList != null) {
            for (String file : fList) {
                if (!file.startsWith(id)) continue;
                try {
                    currPort = Integer.parseInt(file.substring(file.lastIndexOf(95) + 1));
                }
                catch (NumberFormatException nfe) {
                    LOGGER.log(Level.SEVERE, "Cannot parse port", nfe);
                    return false;
                }
                File siFile = new File(SI_FILEDIR, file);
                try (BufferedReader br = new BufferedReader(new FileReader(siFile));){
                    randomNumberString = br.readLine();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.SEVERE, "Cannot read random numbrer from file {0}", siFile.getPath());
                }
                stringId = id;
                LOGGER.log(Level.CONFIG, "Singleton server {0} already running on port {1}", new Object[]{stringId, currPort});
                return true;
            }
        }
        return false;
    }

    public static boolean invoke(ConfigData configData) {
        return Singleton.running(configData.getSourceID()) && Singleton.connectToServer(configData);
    }

    private static void printProperty(PrintStream out, String key, Properties p) {
        out.println(String.format("%s=%s", key, p.getProperty(key, "")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean connectToServer(ConfigData configData) {
        LOGGER.log(Level.CONFIG, "Connect to {0} on port {1}", new Object[]{stringId, currPort});
        if (randomNumberString == null) {
            LOGGER.log(Level.SEVERE, "MAGIC number is null, cannot connect.");
            return false;
        }
        String encodingName = Charset.defaultCharset().name();
        try (Socket socket = new Socket(LOCALHOST, currPort);
             OutputStream os = socket.getOutputStream();
             PrintStream out = new PrintStream(socket.getOutputStream(), true, encodingName);
             InputStreamReader isr = new InputStreamReader(socket.getInputStream(), encodingName);
             BufferedReader br = new BufferedReader(isr);){
            byte[] encoding = new byte[]{1};
            os.write(encoding);
            out.println(randomNumberString);
            out.println(SI_MAGICWORD);
            out.println(SI_ARG);
            for (String arg : configData.getArguments()) {
                out.println(arg);
            }
            out.println(SI_PROP);
            Properties p = configData.getProperties();
            Singleton.printProperty(out, "weasis.user", p);
            Singleton.printProperty(out, "weasis.config.hash", p);
            out.println(SI_EOF);
            out.flush();
            LOGGER.log(Level.FINE, "Waiting for ACK");
            int tries = 5;
            for (int i = 0; i < 5; ++i) {
                String str = br.readLine();
                if (SI_ACK.equals(str)) {
                    LOGGER.log(Level.FINE, "Got ACK");
                    boolean bl = true;
                    return bl;
                }
                if (!SI_EXIT.equals(str)) continue;
                File file = Singleton.getSiFile(stringId, currPort);
                Singleton.waitDeletedFile(file);
                boolean bl = false;
                return bl;
            }
            LOGGER.log(Level.SEVERE, "No ACK from server");
            return false;
        }
        catch (SocketException se) {
            LOGGER.log(Level.SEVERE, "No server is running", se);
            return false;
        }
        catch (Exception ioe) {
            LOGGER.log(Level.SEVERE, "Cannot connect to server", ioe);
        }
        return false;
    }

    private static void waitDeletedFile(File file) {
        int loop = 0;
        boolean runLoop = true;
        while (runLoop) {
            LOGGER.log(Level.INFO, "Wait 100 ms to start a the new instance once the previous has stopped");
            try {
                if (!file.exists()) break;
                TimeUnit.MILLISECONDS.sleep(100L);
                if (++loop <= 300) continue;
                LOGGER.log(Level.SEVERE, "The pid of the singleton still exists. Try to start the new instance.");
                runLoop = false;
            }
            catch (InterruptedException e) {
                runLoop = false;
                Thread.currentThread().interrupt();
            }
        }
    }

    private static File getSiFile(String id, int port) {
        return new File(SI_FILEDIR, id + "_" + port);
    }

    static {
        stringId = null;
        randomNumberString = null;
        siApp = null;
        random = new SecureRandom();
        serverStarted = false;
    }

    private static class SingletonServerRunnable
    implements Runnable {
        final ServerSocket ss;
        final int port;
        final String stringId;

        int getPort() {
            return this.port;
        }

        SingletonServerRunnable(String id) throws IOException {
            this.stringId = id;
            this.ss = new ServerSocket(0, 0, InetAddress.getByName(Singleton.LOCALHOST));
            this.port = this.ss.getLocalPort();
            LOGGER.log(Level.CONFIG, "Local port of the Singleton server: {0}", this.port);
            SingletonServerRunnable.createSingletonFile(this.stringId, this.port);
        }

        private void removeSiFile() {
            File file = Singleton.getSiFile(this.stringId, this.port);
            LOGGER.log(Level.CONFIG, "Removing SingletonFile: {0}", file);
            FileUtil.delete(file);
        }

        private static void createSingletonFile(String id, int port) {
            File siFile = Singleton.getSiFile(id, port);
            AccessController.doPrivileged(() -> {
                SI_FILEDIR.mkdirs();
                String[] fList = SI_FILEDIR.list();
                if (fList != null) {
                    for (String file : fList) {
                        if (!file.startsWith(id)) continue;
                        LOGGER.log(Level.CONFIG, "Remove file with same prefix {0}", file);
                        FileUtil.delete(new File(SI_FILEDIR, file));
                    }
                }
                try (PrintStream out = new PrintStream(new FileOutputStream(siFile));){
                    siFile.deleteOnExit();
                    randomNumber = random.nextInt();
                    out.print(randomNumber);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Cannot add random number to file", e);
                }
                return null;
            });
        }

        @Override
        public void run() {
            AccessController.doPrivileged(this::runSingletonServer);
        }

        private static String getStreamEncoding(InputStream is) throws IOException {
            int encoding = is.read();
            if (encoding == 1) {
                return Charset.defaultCharset().name();
            }
            if (encoding == 2) {
                return Singleton.ENCODING_UNICODE_NAME;
            }
            LOGGER.log(Level.SEVERE, "Unknown encoding: {0}", encoding);
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Void runSingletonServer() {
            while (true) {
                try {
                    while (true) {
                        PrintStream ps;
                        OutputStream os;
                        String line;
                        BufferedReader in;
                        InputStreamReader isr;
                        Socket s;
                        block63: {
                            s = this.ss.accept();
                            InputStream is = s.getInputStream();
                            isr = new InputStreamReader(is, SingletonServerRunnable.getStreamEncoding(is));
                            in = new BufferedReader(isr);
                            LOGGER.log(Level.FINE, "Singleton server is waiting a connection");
                            line = in.readLine();
                            if (line.equals(String.valueOf(randomNumber))) {
                                line = in.readLine();
                                LOGGER.log(Level.FINE, "Recieve message: {0}", line);
                                if (!Singleton.SI_MAGICWORD.equals(line)) {
                                    if (!Singleton.SI_STOP.equals(line)) continue;
                                    this.removeSiFile();
                                    return null;
                                }
                                break block63;
                            } else {
                                this.removeSiFile();
                                this.ss.close();
                                serverStarted = false;
                                LOGGER.log(Level.SEVERE, "Unexpected error: Singleton {0} disabled", this.stringId);
                                Void void_ = null;
                                return void_;
                            }
                            finally {
                                in.close();
                                continue;
                            }
                            finally {
                                isr.close();
                                continue;
                            }
                            finally {
                                if (is == null) continue;
                                is.close();
                                continue;
                            }
                            finally {
                                if (s == null) continue;
                                s.close();
                                continue;
                            }
                        }
                        LOGGER.log(Level.FINE, "Got Magic work");
                        ArrayList<String> recvArgs = new ArrayList<String>();
                        Properties props = new Properties();
                        boolean arg = false;
                        while (true) {
                            try {
                                while (!Singleton.SI_EOF.equals(line = in.readLine())) {
                                    if (Singleton.SI_ARG.equals(line)) {
                                        arg = true;
                                        continue;
                                    }
                                    if (Singleton.SI_PROP.equals(line)) {
                                        arg = false;
                                        continue;
                                    }
                                    if (!Utils.hasText(line)) continue;
                                    if (arg) {
                                        recvArgs.add(line);
                                        continue;
                                    }
                                    String[] vals = line.split("=", 2);
                                    if (vals.length != 2) continue;
                                    props.put(vals[0], vals[1]);
                                }
                            }
                            catch (IOException ioe1) {
                                LOGGER.log(Level.SEVERE, "Reading singleton lock file", ioe1);
                                continue;
                            }
                            break;
                        }
                        if (siApp.canStartNewActivation(props)) {
                            siApp.newActivation(recvArgs);
                            LOGGER.log(Level.FINE, "Sending ACK");
                            os = s.getOutputStream();
                            try {
                                ps = new PrintStream(os, true, isr.getEncoding());
                                try {
                                    ps.println(Singleton.SI_ACK);
                                    ps.flush();
                                    continue;
                                }
                                finally {
                                    ps.close();
                                    continue;
                                }
                            }
                            finally {
                                if (os == null) continue;
                                os.close();
                                continue;
                            }
                        }
                        LOGGER.log(Level.FINE, "Sending EXIT");
                        os = s.getOutputStream();
                        try {
                            ps = new PrintStream(os, true, isr.getEncoding());
                            try {
                                ps.println(Singleton.SI_EXIT);
                                ps.flush();
                            }
                            finally {
                                ps.close();
                            }
                        }
                        finally {
                            if (os != null) {
                                os.close();
                            }
                        }
                        System.exit(0);
                        continue;
                        break;
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.SEVERE, "Starting Singleton server", ex);
                    continue;
                }
                break;
            }
        }
    }

    private static class SingletonServer {
        private final SingletonServerRunnable runnable;
        private final Thread thread;

        SingletonServer(SingletonServerRunnable runnable) throws Exception {
            if ("1.8".equals(System.getProperty("java.specification.version"))) {
                this.thread = new Thread(null, runnable, "SIThread", 0L);
            } else {
                Class<?> clazz = Class.forName("java.lang.Thread");
                Constructor<?> constructor = clazz.getConstructor(ThreadGroup.class, Runnable.class, String.class, Long.TYPE, Boolean.TYPE);
                this.thread = (Thread)constructor.newInstance(null, runnable, "SIThread", 0, false);
            }
            this.thread.setDaemon(true);
            this.runnable = runnable;
        }

        SingletonServer(String stringId) throws Exception {
            this(new SingletonServerRunnable(stringId));
        }

        int getPort() {
            return this.runnable.getPort();
        }

        void start() {
            this.thread.start();
        }
    }

    public static interface SingletonApp {
        public boolean canStartNewActivation(Properties var1);

        public void newActivation(List<String> var1);
    }
}

