/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.weasis.launcher.FileUtil;

public class Utils {
    private Utils() {
    }

    public static boolean getEmptytoFalse(String val) {
        if (Utils.hasText(val)) {
            return Utils.getBoolean(val);
        }
        return false;
    }

    public static boolean geEmptytoTrue(String val) {
        if (Utils.hasText(val)) {
            return Utils.getBoolean(val);
        }
        return true;
    }

    private static boolean getBoolean(String val) {
        return Boolean.TRUE.toString().equalsIgnoreCase(val);
    }

    public static boolean hasLength(CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(String str) {
        return Utils.hasLength((CharSequence)str);
    }

    public static boolean hasText(CharSequence str) {
        if (!Utils.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasText(String str) {
        return Utils.hasText((CharSequence)str);
    }

    public static String getWeasisProtocol(String ... params) {
        Pattern pattern = Pattern.compile("^weasis(-.*)?://.*?");
        for (String p : params) {
            if (!pattern.matcher(p).matches()) continue;
            return p;
        }
        return null;
    }

    public static int getWeasisProtocolIndex(String ... params) {
        Pattern pattern = Pattern.compile("^weasis(-.*)?://.*?");
        for (int i = 0; i < params.length; ++i) {
            if (!pattern.matcher(params[i]).matches()) continue;
            return i;
        }
        return -1;
    }

    public static String removeEnglobingQuotes(String value) {
        return value.replaceAll("^\"|\"$", "");
    }

    public static String adaptPathToUri(String value) {
        return value.replace("\\", "/").replace(" ", "%20");
    }

    public static List<String> splitSpaceExceptInQuotes(String s) {
        String arg;
        if (s == null) {
            return Collections.emptyList();
        }
        ArrayList<String> matchList = new ArrayList<String>();
        Pattern patternSpaceExceptQuotes = Pattern.compile("'[^']*'|\"[^\"]*\"|( )");
        Matcher m = patternSpaceExceptQuotes.matcher(s);
        StringBuffer b = new StringBuffer();
        while (m.find()) {
            if (m.group(1) != null) continue;
            m.appendReplacement(b, m.group(0));
            arg = b.toString();
            b.setLength(0);
            if (!Utils.hasText(arg)) continue;
            matchList.add(arg.trim());
        }
        b.setLength(0);
        m.appendTail(b);
        arg = b.toString();
        if (Utils.hasText(arg)) {
            matchList.add(arg.trim());
        }
        return matchList;
    }

    public static byte[] getByteArrayProperty(Properties prop, String key, byte[] def) {
        String value;
        byte[] result = def;
        if (key != null && Utils.hasText(value = prop.getProperty(key))) {
            try {
                result = FileUtil.gzipUncompressToByte(Base64.getDecoder().decode(value.getBytes()));
            }
            catch (IOException e) {
                Logger.getLogger(Utils.class.getName()).log(Level.SEVERE, "Get byte property", e);
            }
        }
        return result;
    }

    public static byte[] decrypt(byte[] input, String strKey) throws GeneralSecurityException {
        SecretKeySpec skeyspec = new SecretKeySpec(Objects.requireNonNull(strKey).getBytes(), "Blowfish");
        Cipher cipher = Cipher.getInstance("Blowfish");
        cipher.init(2, skeyspec);
        return cipher.doFinal(input);
    }
}

