/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.launcher;

import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;
import org.weasis.launcher.ConfigData;
import org.weasis.launcher.FileUtil;
import org.weasis.launcher.LookAndFeels;
import org.weasis.launcher.Messages;
import org.weasis.launcher.RemotePrefService;
import org.weasis.launcher.SwingResources;
import org.weasis.launcher.Utils;
import org.weasis.launcher.WeasisLoader;
import org.weasis.launcher.WeasisMainFrame;
import sun.misc.Signal;

public class WeasisLauncher {
    private static final Logger LOGGER;
    public static final String BUNDLE_DIR_SWITCH = "-b";
    public static final String SHUTDOWN_HOOK_PROP = "felix.shutdown.hook";
    public static final String CONFIG_PROPERTIES_PROP = "felix.config.properties";
    public static final String CONFIG_PROPERTIES_FILE_VALUE = "config.properties";
    public static final String EXTENDED_PROPERTIES_PROP = "felix.extended.config.properties";
    public static final String EXTENDED_PROPERTIES_FILE_VALUE = "ext-config.properties";
    public static final String CONFIG_DIRECTORY = "conf";
    public static final String END_LINE;
    public static final String APP_PROPERTY_FILE = "weasis.properties";
    public static final String P_WEASIS_VERSION = "weasis.version";
    public static final String P_WEASIS_PROFILE = "weasis.profile";
    public static final String P_WEASIS_NAME = "weasis.name";
    public static final String P_WEASIS_PATH = "weasis.path";
    public static final String P_WEASIS_RES_DATE = "weasis.resources.date";
    public static final String P_WEASIS_CODEBASE_LOCAL = "weasis.codebase.local";
    public static final String P_WEASIS_SOURCE_ID = "weasis.source.id";
    public static final String P_WEASIS_CODEBASE_URL = "weasis.codebase.url";
    public static final String P_WEASIS_CODEBASE_EXT_URL = "weasis.codebase.ext.url";
    public static final String P_WEASIS_CONFIG_HASH = "weasis.config.hash";
    public static final String P_WEASIS_PREFS_URL = "weasis.pref.url";
    public static final String P_WEASIS_CONFIG_URL = "weasis.config.url";
    public static final String P_WEASIS_USER = "weasis.user";
    public static final String P_WEASIS_SHOW_DISCLAIMER = "weasis.show.disclaimer";
    public static final String P_WEASIS_ACCEPT_DISCLAIMER = "weasis.accept.disclaimer";
    public static final String P_WEASIS_SHOW_RELEASE = "weasis.show.release";
    public static final String P_WEASIS_VERSION_RELEASE = "weasis.version.release";
    public static final String P_WEASIS_I18N = "weasis.i18n";
    public static final String P_OS_NAME = "os.name";
    public static final String P_WEASIS_LOOK = "weasis.look";
    public static final String P_GOSH_ARGS = "gosh.args";
    public static final String P_WEASIS_CLEAN_CACHE = "weasis.clean.cache";
    public static final String P_HTTP_AUTHORIZATION = "http.authorization";
    public static final String P_NATIVE_LIB_SPEC = "native.library.spec";
    public static final String P_WEASIS_MIN_NATIVE_VERSION = "weasis.min.native.version";
    public static final String F_RESOURCES = "resources";
    static final String MAC_OS_X = "Mac OS X";
    protected Felix mFelix = null;
    protected ServiceTracker mTracker = null;
    protected volatile boolean frameworkLoaded = false;
    protected String look = null;
    protected RemotePrefService remotePrefs;
    protected String localPrefsDir;
    protected final Properties modulesi18n;
    protected final ConfigData configData;

    public WeasisLauncher(ConfigData configData) {
        this.configData = Objects.requireNonNull(configData);
        this.modulesi18n = new Properties();
    }

    public static void main(String[] argv) throws Exception {
        WeasisLauncher.setSystemProperties(argv);
        WeasisLauncher instance = new WeasisLauncher(new ConfigData(argv));
        instance.launch(Type.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void launch(Type type) throws Exception {
        Map<String, String> serverProp = this.configData.getFelixProps();
        String cacheDir = serverProp.get("org.osgi.framework.storage") + "-" + this.configData.getSourceID();
        serverProp.put("org.osgi.framework.storage", cacheDir);
        if ("1.8".equals(System.getProperty("java.specification.version"))) {
            serverProp.remove("felix.auto.start.7");
        }
        WeasisLoader loader = this.loadProperties(serverProp, this.configData.getConfigOutput());
        WeasisMainFrame mainFrame = loader.getMainFrame();
        String minVersion = System.getProperty(P_WEASIS_MIN_NATIVE_VERSION);
        if (Utils.hasText(minVersion)) {
            EventQueue.invokeAndWait(() -> {
                String appName = System.getProperty(P_WEASIS_NAME);
                int response = JOptionPane.showOptionDialog(mainFrame.getRootPaneContainer() == null ? null : mainFrame.getRootPaneContainer().getContentPane(), String.format(Messages.getString("WeasisLauncher.update_min") + "\n\n" + Messages.getString("WeasisLauncher.continue_local"), appName, minVersion), null, 0, 0, null, null, null);
                if (response != 0) {
                    LOGGER.log(Level.SEVERE, "Do not continue the launch with the local version");
                    System.exit(-1);
                }
            });
        }
        if (Type.JWS == type) {
            WeasisLauncher.handleWebstartHookBug();
            System.setProperty("http.bundle.cache", Boolean.FALSE.toString());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdownHook));
        this.registerAdditionalShutdownHook();
        WeasisLauncher.displayStartingAciiIcon();
        int exitStatus = 0;
        try {
            String goshArgs = WeasisLauncher.getGoshArgs(serverProp);
            this.mFelix = new Felix(serverProp);
            this.mFelix.init();
            loader.setFelix(serverProp, this.mFelix.getBundleContext(), this.modulesi18n);
            loader.writeLabel(String.format(Messages.getString("WeasisLauncher.starting"), System.getProperty(P_WEASIS_NAME)));
            this.mTracker = new ServiceTracker(this.mFelix.getBundleContext(), "org.apache.felix.service.command.CommandProcessor", null);
            this.mTracker.open();
            this.mFelix.start();
            loader.close();
            loader = null;
            String logActivatation = serverProp.get("org.apache.sling.commons.log.file");
            if (Utils.hasText(logActivatation)) {
                LOGGER.log(Level.INFO, "Logs has been delegated to the OSGI service and can be read in {0}", logActivatation);
            }
            this.executeCommands(this.configData.getArguments(), goshArgs);
            this.checkBundleUI(serverProp);
            this.frameworkLoaded = true;
            this.showMessage(mainFrame, serverProp);
            this.mFelix.waitForStop(0L);
            System.exit(0);
        }
        catch (Throwable ex) {
            exitStatus = -1;
            LOGGER.log(Level.SEVERE, "Cannot not start framework.", ex);
            LOGGER.log(Level.SEVERE, "Weasis cache will be cleaned at next launch.");
            LOGGER.log(Level.SEVERE, "State of the framework:");
            for (Bundle b : this.mFelix.getBundleContext().getBundles()) {
                LOGGER.log(Level.SEVERE, " * " + b.getSymbolicName() + "-" + b.getVersion().toString() + " " + State.valueOf(b.getState()));
            }
            WeasisLauncher.resetBundleCache();
        }
        finally {
            Runtime.getRuntime().halt(exitStatus);
        }
    }

    @Deprecated
    private static void setSystemProperties(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[i].startsWith("-VMP") || argv[i].length() <= 4) continue;
            String[] vmarg = argv[i].substring(4).split("=", 2);
            argv[i] = "";
            if (vmarg.length != 2) continue;
            if (vmarg[1].startsWith("\"") && vmarg[1].endsWith("\"")) {
                vmarg[1] = vmarg[1].substring(1, vmarg[1].length() - 1);
            }
            System.setProperty(vmarg[0], Util.substVars((String)vmarg[1], (String)vmarg[0], null, null));
        }
    }

    private void checkBundleUI(Map<String, String> serverProp) {
        String mainUI = serverProp.getOrDefault("weasis.main.ui", "").trim();
        if (Utils.hasText(mainUI)) {
            boolean uiStarted = false;
            for (Bundle b : this.mFelix.getBundleContext().getBundles()) {
                if (!b.getSymbolicName().equals(mainUI) || b.getState() != 32) continue;
                uiStarted = true;
                break;
            }
            if (!uiStarted) {
                throw new IllegalStateException("Main User Interface bundle cannot be started");
            }
        }
    }

    private static String getGoshArgs(Map<String, String> serverProp) {
        String val;
        String goshArgs = System.getProperty(P_GOSH_ARGS, serverProp.getOrDefault(P_GOSH_ARGS, ""));
        if (goshArgs.isEmpty() && !(val = System.getProperty("gosh.port", "")).isEmpty()) {
            try {
                goshArgs = String.format("-sc telnetd -p %d start", Integer.parseInt(val));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        serverProp.put(P_GOSH_ARGS, "--nointeractive --noshutdown");
        return goshArgs;
    }

    private static void displayStartingAciiIcon() {
        StringBuilder buf = new StringBuilder();
        buf.append(END_LINE);
        buf.append("Starting OSGI Bundles...");
        buf.append(END_LINE);
        buf.append(END_LINE);
        buf.append("         | | /| / /__ ___ ____ (_)__");
        buf.append(END_LINE);
        buf.append("         | |/ |/ / -_) _ `(_-</ (_-<");
        buf.append(END_LINE);
        buf.append("         |__/|__/\\__/\\_,_/___/_/___/");
        buf.append(END_LINE);
        LOGGER.log(Level.INFO, buf::toString);
    }

    protected void executeCommands(List<String> commandList, String goshArgs) {
        SwingUtilities.invokeLater(() -> {
            this.mTracker.open();
            Object commandSession = WeasisLauncher.getCommandSession(this.mTracker.getService(), new Object[]{new FileInputStream(FileDescriptor.in), new FileOutputStream(FileDescriptor.out), new FileOutputStream(FileDescriptor.err)});
            if (commandSession != null) {
                if (goshArgs == null) {
                    WeasisLauncher.commandSessionExecute(commandSession, "weasis:ui -v");
                } else {
                    WeasisLauncher.initCommandSession(commandSession, goshArgs);
                }
                for (String command : commandList) {
                    WeasisLauncher.commandSessionExecute(commandSession, command);
                }
                WeasisLauncher.commandSessionClose(commandSession);
            }
            this.mTracker.close();
        });
    }

    private static void resetBundleCache() {
        File sourceIdProps = new File(System.getProperty(P_WEASIS_PATH, ""), System.getProperty(P_WEASIS_SOURCE_ID) + ".properties");
        Properties localSourceProp = new Properties();
        FileUtil.readProperties(sourceIdProps, localSourceProp);
        localSourceProp.setProperty(P_WEASIS_CLEAN_CACHE, Boolean.TRUE.toString());
        FileUtil.storeProperties(sourceIdProps, localSourceProp, null);
    }

    private void showMessage(WeasisMainFrame mainFrame, Map<String, String> serverProp) {
        String val;
        String versionOld = serverProp.get("prev.weasis.version");
        String versionNew = serverProp.getOrDefault(P_WEASIS_VERSION, "0.0.0");
        if (versionOld == null) {
            String val2 = serverProp.get("prev.weasis.show.disclaimer");
            String accept = serverProp.get(P_WEASIS_ACCEPT_DISCLAIMER);
            if (Utils.geEmptytoTrue(val2) && !Utils.getEmptytoFalse(accept)) {
                EventQueue.invokeLater(() -> {
                    Object[] options = new Object[]{Messages.getString("WeasisLauncher.ok"), Messages.getString("WeasisLauncher.no")};
                    String appName = System.getProperty(P_WEASIS_NAME);
                    int response = JOptionPane.showOptionDialog(mainFrame.getRootPaneContainer() == null ? null : mainFrame.getRootPaneContainer().getContentPane(), String.format(Messages.getString("WeasisLauncher.msg"), appName), String.format(Messages.getString("WeasisLauncher.first"), appName), 0, 2, null, options, null);
                    if (response == 0) {
                        System.setProperty(P_WEASIS_ACCEPT_DISCLAIMER, Boolean.TRUE.toString());
                    } else {
                        File file = new File(System.getProperty(P_WEASIS_PATH, ""), System.getProperty(P_WEASIS_SOURCE_ID) + ".properties");
                        FileUtil.delete(file);
                        LOGGER.log(Level.SEVERE, "Refusing the disclaimer");
                        System.exit(-1);
                    }
                });
            }
        } else if (versionNew != null && !versionNew.equals(versionOld) && Utils.geEmptytoTrue(val = serverProp.get("prev.weasis.show.release"))) {
            try {
                Version vOld = WeasisLauncher.getVersion(versionOld);
                Version vNew = WeasisLauncher.getVersion(versionNew);
                if (vNew.compareTo(vOld) > 0) {
                    String lastTag = serverProp.get(P_WEASIS_VERSION_RELEASE);
                    if (lastTag != null && vNew.compareTo(vOld = WeasisLauncher.getVersion(lastTag)) <= 0) {
                        return;
                    }
                    System.setProperty(P_WEASIS_VERSION_RELEASE, vNew.toString());
                }
            }
            catch (Exception e2) {
                LOGGER.log(Level.SEVERE, "Cannot read version", e2);
                return;
            }
            String releaseNotesUrl = serverProp.get("weasis.releasenotes");
            StringBuilder message = new StringBuilder("<P>");
            message.append(String.format(Messages.getString("WeasisLauncher.change.version"), System.getProperty(P_WEASIS_NAME), versionOld, versionNew));
            EventQueue.invokeLater(() -> {
                JTextPane jTextPane1 = new JTextPane();
                HTMLEditorKit kit = new HTMLEditorKit();
                StyleSheet ss = kit.getStyleSheet();
                ss.addRule("body {font-family:sans-serif;font-size:12pt;background-color:#" + Integer.toHexString(jTextPane1.getBackground().getRGB() & 0xFFFFFF | 0x1000000).substring(1) + ";color:#" + Integer.toHexString(jTextPane1.getForeground().getRGB() & 0xFFFFFF | 0x1000000).substring(1) + ";margin:3;font-weight:normal;}");
                jTextPane1.setContentType("text/html");
                jTextPane1.setEditable(false);
                jTextPane1.addHyperlinkListener(e -> {
                    JTextPane pane = (JTextPane)e.getSource();
                    if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                        pane.setToolTipText(e.getDescription());
                    } else if (e.getEventType() == HyperlinkEvent.EventType.EXITED) {
                        pane.setToolTipText(null);
                    } else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Desktop desktop;
                        if (System.getProperty(P_OS_NAME, "unknown").toLowerCase().startsWith("linux")) {
                            try {
                                String cmd = String.format("xdg-open %s", e.getURL());
                                Runtime.getRuntime().exec(cmd);
                            }
                            catch (IOException e1) {
                                LOGGER.log(Level.SEVERE, "Unable to launch the WEB browser");
                            }
                        } else if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                            try {
                                desktop.browse(e.getURL().toURI());
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.SEVERE, "Unable to launch the WEB browser");
                            }
                        }
                    }
                });
                message.append("<BR>");
                String rn = Messages.getString("WeasisLauncher.release");
                message.append(String.format("<a href=\"%s", releaseNotesUrl));
                message.append("\" style=\"color:#FF9900\">");
                message.append(rn);
                message.append("</a>");
                message.append("</P>");
                jTextPane1.setText(message.toString());
                JOptionPane.showMessageDialog(mainFrame.getRootPaneContainer() == null ? null : mainFrame.getRootPaneContainer().getContentPane(), jTextPane1, Messages.getString("WeasisLauncher.News"), -1);
            });
        }
    }

    private static Version getVersion(String version) {
        String v = "";
        if (version != null) {
            int index = version.indexOf(45);
            v = index > 0 ? version.substring(0, index) : version;
        }
        return new Version(v);
    }

    public static Object getCommandSession(Object commandProcessor, Object[] arguments) {
        if (commandProcessor == null) {
            return null;
        }
        Class[] parameterTypes = new Class[]{InputStream.class, OutputStream.class, OutputStream.class};
        try {
            Method nameMethod = commandProcessor.getClass().getMethod("createSession", parameterTypes);
            Object commandSession = nameMethod.invoke(commandProcessor, arguments);
            WeasisLauncher.addCommandSessionListener(commandProcessor);
            return commandSession;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Create a command session", ex);
            return null;
        }
    }

    private static void addCommandSessionListener(Object commandProcessor) {
        try {
            ClassLoader loader = commandProcessor.getClass().getClassLoader();
            Class<?> c = loader.loadClass("org.apache.felix.service.command.CommandSessionListener");
            Method nameMethod = commandProcessor.getClass().getMethod("addListener", c);
            Object listener = Proxy.newProxyInstance(loader, new Class[]{c}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    String listenerMethod = method.getName();
                    if (listenerMethod.equals("beforeExecute")) {
                        String arg = args[1].toString();
                        if (arg.startsWith("gosh") || arg.startsWith("gogo:gosh")) {
                            WeasisLauncher.commandSessionExecute(args[0], "gogo.option.noglob=on");
                        }
                    } else if (listenerMethod.equals("equals")) {
                        return proxy.getClass().isAssignableFrom(args[0].getClass());
                    }
                    return null;
                }
            });
            nameMethod.invoke(commandProcessor, listener);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Add command session listener", e);
        }
    }

    public static boolean initCommandSession(Object commandSession, String args) {
        try {
            for (int i = 0; i < 100 && WeasisLauncher.commandSessionGet(commandSession, "gogo:gosh") == null; ++i) {
                TimeUnit.MILLISECONDS.sleep(10L);
            }
            Class[] parameterTypes = new Class[]{CharSequence.class};
            Object[] arguments = new Object[]{"gogo:gosh --login " + (args == null ? "" : args)};
            Method nameMethod = commandSession.getClass().getMethod("execute", parameterTypes);
            nameMethod.invoke(commandSession, arguments);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Init command session", e);
        }
        return false;
    }

    public static Object commandSessionGet(Object commandSession, String key) {
        if (commandSession == null || key == null) {
            return null;
        }
        Class[] parameterTypes = new Class[]{String.class};
        Object[] arguments = new Object[]{key};
        try {
            Method nameMethod = commandSession.getClass().getMethod("get", parameterTypes);
            return nameMethod.invoke(commandSession, arguments);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Invoke a command", ex);
            return null;
        }
    }

    public static boolean commandSessionClose(Object commandSession) {
        if (commandSession == null) {
            return false;
        }
        try {
            Method nameMethod = commandSession.getClass().getMethod("close", new Class[0]);
            nameMethod.invoke(commandSession, new Object[0]);
            return true;
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Close command session", ex);
            return false;
        }
    }

    public static Object commandSessionExecute(Object commandSession, CharSequence charSequence) {
        if (commandSession == null) {
            return false;
        }
        Class[] parameterTypes = new Class[]{CharSequence.class};
        Object[] arguments = new Object[]{charSequence};
        try {
            Method nameMethod = commandSession.getClass().getMethod("execute", parameterTypes);
            return nameMethod.invoke(commandSession, arguments);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Execute command", ex);
            return null;
        }
    }

    public static void readProperties(URI propURI, Properties props) {
        try (InputStream is = FileUtil.getAdaptedConnection(propURI.toURL(), false).getInputStream();){
            props.load(is);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, ex, () -> String.format("Cannot read properties file: %s", propURI));
        }
    }

    private static String getGeneralProperty(String key, String defaultValue, Map<String, String> serverProp, Properties localProp, boolean storeInLocalPref, boolean serviceProperty) {
        String value = localProp.getProperty(key, null);
        String defaultVal = System.getProperty(key, null);
        if (defaultVal == null) {
            defaultVal = serverProp.getOrDefault(key, defaultValue);
        }
        if (value == null) {
            value = defaultVal;
            if (storeInLocalPref && value != null) {
                localProp.setProperty(key, value);
            }
        }
        if (serviceProperty) {
            serverProp.put(key, value);
            serverProp.put("def." + key, defaultVal);
        }
        LOGGER.log(Level.CONFIG, "Config of {0} = {1}", new Object[]{key, value});
        return value;
    }

    public WeasisLoader loadProperties(Map<String, String> serverProp, StringBuilder conf) {
        String showRelease;
        String showDisclaimer;
        String dir = this.configData.getProperty(P_WEASIS_PATH);
        String profileName = this.configData.getProperty(P_WEASIS_PROFILE, "default");
        String user = this.configData.getProperty(P_WEASIS_USER);
        this.configData.applyProxy(dir + File.separator + "data" + File.separator + "weasis-core-ui");
        StringBuilder bufDir = new StringBuilder(dir);
        bufDir.append(File.separator);
        bufDir.append("preferences");
        bufDir.append(File.separator);
        bufDir.append(user);
        bufDir.append(File.separator);
        bufDir.append(profileName);
        File prefDir = new File(bufDir.toString());
        try {
            prefDir.mkdirs();
        }
        catch (Exception e) {
            prefDir = new File(dir);
            LOGGER.log(Level.SEVERE, "Cannot create preferences folders", e);
        }
        this.localPrefsDir = prefDir.getPath();
        serverProp.put("weasis.pref.dir", prefDir.getPath());
        Properties currentProps = new Properties();
        FileUtil.readProperties(new File(prefDir, APP_PROPERTY_FILE), currentProps);
        currentProps.stringPropertyNames().forEach(key -> serverProp.put("wp.init." + key, currentProps.getProperty((String)key)));
        String remotePrefURL = this.configData.getProperty(P_WEASIS_PREFS_URL);
        if (Utils.hasText(remotePrefURL)) {
            String storeLocalSession = "weasis.pref.store.local.session";
            String defaultVal = this.configData.getProperty(storeLocalSession, null);
            if (defaultVal == null) {
                defaultVal = serverProp.getOrDefault(storeLocalSession, Boolean.FALSE.toString());
            }
            serverProp.put(storeLocalSession, defaultVal);
            try {
                this.remotePrefs = new RemotePrefService(remotePrefURL, serverProp, user, profileName);
                Properties remote = this.remotePrefs.readLauncherPref(null);
                currentProps.putAll((Map<?, ?>)remote);
                if (remote.size() < currentProps.size()) {
                    serverProp.put("wp.init.diff.remote.pref", Boolean.TRUE.toString());
                }
            }
            catch (Exception e) {
                String msg = String.format("Cannot read Launcher preference for user: %s", user);
                LOGGER.log(Level.SEVERE, e, () -> msg);
            }
        }
        String lang = WeasisLauncher.getGeneralProperty("locale.lang.code", "en", serverProp, currentProps, true, false);
        WeasisLauncher.getGeneralProperty("locale.format.code", "system", serverProp, currentProps, true, false);
        WeasisLauncher.getGeneralProperty("org.apache.sling.commons.log.level", "INFO", serverProp, currentProps, true, true);
        String logActivatation = WeasisLauncher.getGeneralProperty("org.apache.sling.commons.log.file.activate", Boolean.FALSE.toString(), serverProp, currentProps, true, true);
        if (Utils.getEmptytoFalse(logActivatation)) {
            String logFile = dir + File.separator + "log" + File.separator + "default.log";
            serverProp.put("org.apache.sling.commons.log.file", logFile);
            currentProps.remove("org.apache.sling.commons.log.file");
        }
        WeasisLauncher.getGeneralProperty("org.apache.sling.commons.log.file.number", "5", serverProp, currentProps, true, true);
        WeasisLauncher.getGeneralProperty("org.apache.sling.commons.log.file.size", "10MB", serverProp, currentProps, true, true);
        WeasisLauncher.getGeneralProperty("org.apache.sling.commons.log.stack.limit", "3", serverProp, currentProps, true, true);
        WeasisLauncher.getGeneralProperty("org.apache.sling.commons.log.pattern", "{0,date,dd.MM.yyyy HH:mm:ss.SSS} *{4}* [{2}] {3}: {5}", serverProp, currentProps, false, true);
        this.loadI18nModules();
        Locale locale = WeasisLauncher.textToLocale(lang);
        if (Locale.ENGLISH.equals(locale)) {
            this.modulesi18n.clear();
        } else {
            String suffix = locale.toString();
            SwingResources.loadResources("/swing/basic_" + suffix + ".properties");
            SwingResources.loadResources("/swing/synth_" + suffix + ".properties");
        }
        Locale.setDefault(locale);
        UIManager.getDefaults().setDefaultLocale(locale);
        JComponent.setDefaultLocale(locale);
        String sysSpec = System.getProperty(P_NATIVE_LIB_SPEC, "unknown");
        int index = sysSpec.indexOf(45);
        if (index > 0) {
            String nativeLook = "weasis.look." + sysSpec.substring(0, index);
            this.look = System.getProperty(nativeLook, null);
            if (this.look == null) {
                this.look = serverProp.get(nativeLook);
            }
        }
        if (this.look == null) {
            this.look = System.getProperty(P_WEASIS_LOOK, null);
            if (this.look == null) {
                this.look = serverProp.get(P_WEASIS_LOOK);
            }
        }
        String localLook = currentProps.getProperty(P_WEASIS_LOOK, null);
        if (LookAndFeels.installSubstanceLookAndFeels() && this.look == null) {
            this.look = MAC_OS_X.equals(System.getProperty(P_OS_NAME)) ? "com.apple.laf.AquaLookAndFeel" : "org.pushingpixels.substance.api.skin.SubstanceTwilightLookAndFeel";
        }
        if (this.look == null) {
            this.look = WeasisLauncher.getAvailableLookAndFeel(this.look);
        }
        serverProp.put(P_WEASIS_LOOK, this.look);
        if (localLook != null) {
            this.look = localLook;
        }
        WeasisMainFrame mainFrame = new WeasisMainFrame();
        try {
            SwingUtilities.invokeAndWait(() -> {
                boolean substance = this.look.startsWith("org.pushingpixels");
                if (substance) {
                    JDialog.setDefaultLookAndFeelDecorated(true);
                }
                this.look = WeasisLauncher.setLookAndFeel(this.look);
                try {
                    ObjectName objectName2 = new ObjectName("weasis:name=MainWindow");
                    mainFrame.setRootPaneContainer(new JFrame());
                    ManagementFactory.getPlatformMBeanServer().registerMBean(mainFrame, objectName2);
                }
                catch (Exception e1) {
                    LOGGER.log(Level.SEVERE, "Cannot register the main frame", e1);
                }
            });
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to set the Look&Feel {0}", this.look);
        }
        currentProps.put(P_WEASIS_LOOK, this.look);
        File sourceIDProps = new File(dir, this.configData.getProperty(P_WEASIS_SOURCE_ID) + ".properties");
        Properties localSourceProp = new Properties();
        FileUtil.readProperties(sourceIDProps, localSourceProp);
        String versionOld = localSourceProp.getProperty(P_WEASIS_VERSION);
        if (Utils.hasText(versionOld)) {
            serverProp.put("prev.weasis.version", versionOld);
        }
        String versionNew = serverProp.getOrDefault(P_WEASIS_VERSION, "0.0.0");
        String cleanCacheAfterCrash = localSourceProp.getProperty(P_WEASIS_CLEAN_CACHE);
        boolean update = false;
        String defaultResources = "/resources.zip";
        String resPath = serverProp.getOrDefault("weasis.resources.url", this.configData.getProperty(P_WEASIS_CODEBASE_URL, "") + defaultResources);
        File cacheDir = null;
        boolean mavenRepo = Utils.hasText(System.getProperty("maven.localRepository", null));
        String cdbl = this.configData.getProperty(P_WEASIS_CODEBASE_LOCAL);
        boolean localRes = mavenRepo || new File(cdbl, F_RESOURCES).exists();
        try {
            String date;
            if (!localRes && resPath.endsWith(".zip") && !resPath.equals(defaultResources) && (date = FileUtil.writeResources(resPath, cacheDir = new File(dir + File.separator + "data" + File.separator + System.getProperty(P_WEASIS_SOURCE_ID), F_RESOURCES), localSourceProp.getProperty(P_WEASIS_RES_DATE))) != null) {
                update = true;
                localSourceProp.put(P_WEASIS_RES_DATE, date);
            }
        }
        catch (Exception e) {
            cacheDir = null;
            LOGGER.log(Level.SEVERE, "Loads the resource folder", e);
        }
        if (cacheDir == null) {
            if (mavenRepo) {
                File f = new File(System.getProperty("user.dir"));
                cacheDir = new File(f.getParent(), "weasis-distributions" + File.separator + F_RESOURCES);
            } else {
                cacheDir = new File(cdbl, F_RESOURCES);
            }
        }
        serverProp.put("weasis.resources.path", cacheDir.getPath());
        WeasisLoader loader = new WeasisLoader(cacheDir, mainFrame);
        loader.open();
        if (versionNew != null) {
            localSourceProp.put(P_WEASIS_VERSION, versionNew);
            if (versionOld == null || !versionOld.equals(versionNew)) {
                update = true;
            }
        }
        if (Utils.hasText(showDisclaimer = WeasisLauncher.getGeneralProperty(P_WEASIS_SHOW_DISCLAIMER, Boolean.TRUE.toString(), serverProp, currentProps, false, false))) {
            serverProp.put("prev.weasis.show.disclaimer", showDisclaimer);
        }
        if (Utils.hasText(showRelease = WeasisLauncher.getGeneralProperty(P_WEASIS_SHOW_RELEASE, Boolean.TRUE.toString(), serverProp, currentProps, false, false))) {
            serverProp.put("prev.weasis.show.release", showRelease);
        }
        boolean cleanCache = Boolean.parseBoolean(serverProp.get("weasis.clean.previous.version"));
        if (cleanCacheAfterCrash != null && Boolean.TRUE.toString().equals(cleanCacheAfterCrash)) {
            serverProp.put("org.osgi.framework.storage.clean", "onFirstInit");
            localSourceProp.remove(P_WEASIS_CLEAN_CACHE);
            update = true;
            LOGGER.log(Level.INFO, "Clean plug-in cache because Weasis has crashed during the previous launch");
        } else if (cleanCache && versionNew != null && !versionNew.equals(versionOld)) {
            LOGGER.log(Level.INFO, "Clean previous Weasis version: {0}", versionOld);
            serverProp.put("org.osgi.framework.storage.clean", "onFirstInit");
            LOGGER.log(Level.INFO, "Clean plug-in cache because the version has changed");
        }
        if (update) {
            FileUtil.storeProperties(sourceIDProps, localSourceProp, null);
        }
        Set<String> pKeys = currentProps.stringPropertyNames();
        serverProp.put("wp.list", String.join((CharSequence)",", pKeys));
        pKeys.forEach(key -> serverProp.put((String)key, currentProps.getProperty((String)key)));
        String pevConf = conf.toString();
        conf.setLength(0);
        conf.append("\n***** Configuration *****");
        conf.append("\n  Last running version = ");
        conf.append(versionOld);
        conf.append("\n  Current version = ");
        conf.append(versionNew);
        conf.append("\n  Application name = ");
        conf.append(this.configData.getProperty(P_WEASIS_NAME));
        conf.append("\n  Application Source ID = ");
        conf.append(System.getProperty(P_WEASIS_SOURCE_ID));
        conf.append("\n  Application Profile = ");
        conf.append(profileName);
        conf.append(pevConf);
        conf.append("\n  User = ");
        conf.append(System.getProperty(P_WEASIS_USER, "user"));
        conf.append("\n  User home directory = ");
        conf.append(dir);
        conf.append("\n  Resources path = ");
        conf.append(cacheDir.getPath());
        conf.append("\n  Preferences directory = ");
        conf.append(prefDir.getPath());
        conf.append("\n  Look and Feel = ");
        conf.append(this.look);
        String i18nPath = System.getProperty(P_WEASIS_I18N);
        if (Utils.hasText(i18nPath)) {
            conf.append("\n  Languages path = ");
            conf.append(i18nPath);
        }
        conf.append("\n  Languages available = ");
        conf.append(System.getProperty("weasis.languages", "en"));
        conf.append("\n  OSGI native specs = ");
        conf.append(System.getProperty(P_NATIVE_LIB_SPEC));
        conf.append("\n  HTTP user agent = ");
        conf.append(System.getProperty("http.agent"));
        conf.append("\n  Operating system = ");
        conf.append(System.getProperty(P_OS_NAME));
        conf.append(' ');
        conf.append(System.getProperty("os.version"));
        conf.append(' ');
        conf.append(System.getProperty("os.arch"));
        conf.append("\n  Java vendor = ");
        conf.append(System.getProperty("java.vendor"));
        conf.append("\n  Java version = ");
        conf.append(System.getProperty("java.version"));
        conf.append("\n  Java Path = ");
        conf.append(System.getProperty("java.home"));
        conf.append("\n  Java max memory (less survivor space) = ");
        conf.append(FileUtil.humanReadableByteCount(Runtime.getRuntime().maxMemory(), false));
        conf.append("\n***** End of Configuration *****");
        LOGGER.log(Level.INFO, conf::toString);
        return loader;
    }

    private void loadI18nModules() {
        try {
            String cdb;
            String cdbl = this.configData.getProperty(P_WEASIS_CODEBASE_LOCAL);
            String path = this.configData.getProperty(P_WEASIS_I18N, null);
            if (Utils.hasText(path)) {
                path = path + (path.endsWith("/") ? "buildNumber.properties" : "/buildNumber.properties");
                WeasisLauncher.readProperties(new URI(path), this.modulesi18n);
            } else if (cdbl == null && Utils.hasText(cdb = this.configData.getProperty(P_WEASIS_CODEBASE_URL, null))) {
                path = cdb.substring(0, cdb.lastIndexOf(47)) + "/weasis-i18n";
                WeasisLauncher.readProperties(new URI(path + "/buildNumber.properties"), this.modulesi18n);
                if (!this.modulesi18n.isEmpty()) {
                    System.setProperty(P_WEASIS_I18N, path);
                }
            }
            if (this.modulesi18n.isEmpty()) {
                File file;
                if (cdbl == null) {
                    cdbl = ConfigData.findLocalCodebase().getPath();
                }
                if ((file = new File(cdbl, "bundle-i18n" + File.separator + "buildNumber.properties")).canRead()) {
                    WeasisLauncher.readProperties(file.toURI(), this.modulesi18n);
                    if (!this.modulesi18n.isEmpty()) {
                        System.setProperty(P_WEASIS_I18N, file.getParentFile().toURI().toString());
                    }
                }
            }
            if (!this.modulesi18n.isEmpty()) {
                System.setProperty("weasis.languages", this.modulesi18n.getProperty("languages", ""));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Cannot load translation modules", e);
        }
    }

    public static String setLookAndFeel(String look) {
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        UIManager.put("Slider.paintValue", Boolean.FALSE);
        String laf = WeasisLauncher.getAvailableLookAndFeel(look);
        try {
            UIManager.setLookAndFeel(laf);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unable to set the Look&Feel", e);
            laf = UIManager.getSystemLookAndFeelClassName();
        }
        LookAndFeels.setUIFont(new FontUIResource("SansSerif", 0, 12));
        return laf;
    }

    public static String getAvailableLookAndFeel(String look) {
        int i;
        int n;
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        String laf = null;
        if (look != null) {
            n = lafs.length;
            for (i = 0; i < n; ++i) {
                if (!lafs[i].getClassName().equals(look)) continue;
                laf = look;
                break;
            }
        }
        if (laf == null) {
            if (MAC_OS_X.equals(System.getProperty(P_OS_NAME))) {
                laf = "com.apple.laf.AquaLookAndFeel";
            } else {
                n = lafs.length;
                for (i = 0; i < n; ++i) {
                    if (!lafs[i].getName().equals("Nimbus")) continue;
                    laf = lafs[i].getClassName();
                    break;
                }
            }
            if (laf == null) {
                laf = UIManager.getSystemLookAndFeelClassName();
            }
        }
        return laf;
    }

    public static Locale textToLocale(String value) {
        if (!Utils.hasText(value)) {
            return Locale.ENGLISH;
        }
        if ("system".equals(value)) {
            String language = System.getProperty("user.language", "en");
            String country = System.getProperty("user.country", "");
            String variant = System.getProperty("user.variant", "");
            return new Locale(language, country, variant);
        }
        String[] val = value.split("_", 3);
        String language = val.length > 0 ? val[0] : "";
        String country = val.length > 1 ? val[1] : "";
        String variant = val.length > 2 ? val[2] : "";
        return new Locale(language, country, variant);
    }

    private void registerAdditionalShutdownHook() {
        try {
            Class.forName("sun.misc.Signal");
            Class.forName("sun.misc.SignalHandler");
            Signal.handle(new Signal("TERM"), signal -> this.shutdownHook());
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.SEVERE, "Register shutdownHook", e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.log(Level.SEVERE, "Cannot find sun.misc.Signal for shutdown hook exstension", e);
        }
    }

    public static int getJavaMajorVersion() {
        String jvmVersionString = System.getProperty("java.specification.version");
        int verIndex = jvmVersionString.indexOf("1.");
        if (verIndex >= 0) {
            jvmVersionString = jvmVersionString.substring(verIndex + 2);
        }
        return Integer.parseInt(jvmVersionString);
    }

    private static void handleWebstartHookBug() {
        if (WeasisLauncher.getJavaMajorVersion() < 9) {
            try {
                Class<?> clazz = Class.forName("java.lang.ApplicationShutdownHooks");
                Field field = clazz.getDeclaredField("hooks");
                field.setAccessible(true);
                Map hooks = (Map)field.get(clazz);
                Iterator it = hooks.values().iterator();
                while (it.hasNext()) {
                    Thread thread = (Thread)it.next();
                    if (!"javawsSecurityThreadGroup".equals(thread.getThreadGroup().getName())) continue;
                    it.remove();
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "JWS shutdownHook", e);
            }
        }
    }

    private void shutdownHook() {
        try {
            if (this.mFelix != null) {
                this.mFelix.stop();
                this.mFelix.waitForStop(30000L);
            }
        }
        catch (Exception ex) {
            System.err.println("Error stopping framework: " + ex);
        }
        finally {
            WeasisLauncher.cleanImageCache();
            this.stopSingletonServer();
            Timer timer = new Timer();
            timer.schedule((TimerTask)new HaltTask(), 15000L);
        }
    }

    protected void stopSingletonServer() {
    }

    static void cleanImageCache() {
        String dir = System.getProperty("weasis.tmp.dir");
        if (Utils.hasText(dir)) {
            FileUtil.deleteDirectoryContents(new File(dir), 3, 0);
        }
    }

    static {
        InputStream loggerProps = WeasisLauncher.class.getResourceAsStream(System.getProperty("java.logging.path", "/logging.properties"));
        try {
            LogManager.getLogManager().readConfiguration(loggerProps);
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
        }
        LOGGER = Logger.getLogger(WeasisLauncher.class.getName());
        END_LINE = System.lineSeparator();
    }

    static class HaltTask
    extends TimerTask {
        HaltTask() {
        }

        @Override
        public void run() {
            System.out.println("Force to close the application");
            Runtime.getRuntime().halt(1);
        }
    }

    public static enum State {
        UNINSTALLED(1),
        INSTALLED(2),
        RESOLVED(4),
        STARTING(8),
        STOPPING(16),
        ACTIVE(32);

        private int index;

        private State(int state) {
            this.index = state;
        }

        public static String valueOf(int state) {
            for (State s : State.values()) {
                if (s.index != state) continue;
                return s.name();
            }
            return "UNKNOWN";
        }
    }

    public static enum Type {
        DEFAULT,
        NATIVE,
        JWS;

    }
}

